/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.core.VConnection;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class TimeStampParser {
    private static final int ASCII_OFFSET = 48;
    private byte[] m_columnData;
    private int m_timezoneOffset = 0;
    private int m_tzStart = 0;
    private int m_fraction = 0;

    public TimeStampParser() {
    }

    public TimeStampParser(byte[] byArray) {
        this.setData(byArray);
    }

    public void setData(byte[] byArray) {
        this.m_columnData = byArray;
        this.m_tzStart = this.m_columnData.length - 1;
        while (this.m_tzStart >= 0 && this.m_columnData[this.m_tzStart] != 43 && this.m_columnData[this.m_tzStart] != 45) {
            --this.m_tzStart;
        }
        this.m_fraction = this.parseFraction();
        this.m_timezoneOffset = this.parseTimeZoneOffSet();
    }

    private int parseTimeZoneOffSet() {
        int n = this.m_columnData[this.m_tzStart] == 45 ? -1 : 1;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[3];
        for (int i = this.m_tzStart + 1; i < this.m_columnData.length; ++i) {
            if (this.m_columnData[i] == 58) {
                ++n2;
                continue;
            }
            if (this.m_columnData[i] == 32) break;
            nArray[n2] = this.m_columnData[i] - 48 + nArray[n2] * 10;
        }
        n3 = nArray[0] * 60 * 60 * 1000 + nArray[1] * 60 * 1000 + nArray[2] * 1000;
        return n3 *= n;
    }

    public final int getTimzoneOffset() {
        return this.m_timezoneOffset;
    }

    public final String getTimezoneId() throws UnsupportedEncodingException {
        return new String(this.m_columnData, this.m_tzStart, this.m_columnData.length - this.m_tzStart, VConnection.VERTICA_CHARSET);
    }

    private Calendar getTimeZoneCalendar() throws UnsupportedEncodingException {
        return Calendar.getInstance(new SimpleTimeZone(this.m_timezoneOffset, this.getTimezoneId()));
    }

    private int getYearWidth() {
        return TimeStampParser.BytesIndexOf(this.m_columnData, '-');
    }

    private static int intFromBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 *= 10;
            n3 += byArray[i] - 48;
        }
        return n3;
    }

    public Calendar getCalendar(int n) throws UnsupportedEncodingException {
        Calendar calendar = null;
        calendar = n == 13 ? this.getTimeZoneCalendar() : Calendar.getInstance();
        this.setCalendar(n, calendar);
        return calendar;
    }

    public void setCalendar(int n, Calendar calendar) {
        int n2 = this.getYearWidth();
        calendar.set(1, TimeStampParser.intFromBytes(this.m_columnData, 0, n2));
        calendar.set(2, TimeStampParser.intFromBytes(this.m_columnData, n2 + 1, 2) - 1);
        calendar.set(5, TimeStampParser.intFromBytes(this.m_columnData, n2 + 4, 2));
        if (n != 10) {
            calendar.set(11, TimeStampParser.intFromBytes(this.m_columnData, n2 + 7, 2));
            calendar.set(12, TimeStampParser.intFromBytes(this.m_columnData, n2 + 10, 2));
            calendar.set(13, TimeStampParser.intFromBytes(this.m_columnData, n2 + 13, 2));
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        if (this.m_columnData[this.m_columnData.length - 2] == 66 && this.m_columnData[this.m_columnData.length - 1] == 67) {
            calendar.set(0, 0);
        }
    }

    public static int BytesIndexOf(byte[] byArray, char c) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    private int parseFraction() {
        if (this.m_columnData.length == 0) {
            return 0;
        }
        int n = TimeStampParser.BytesIndexOf(this.m_columnData, '.');
        if (n == -1) {
            return 0;
        }
        int n2 = 0;
        int n3 = 100000;
        ++n;
        while (n < this.m_columnData.length && this.m_columnData[n] != 43 && this.m_columnData[n] != 45) {
            n2 += (this.m_columnData[n] - 48) * n3;
            n3 /= 10;
            ++n;
        }
        return n2;
    }

    public final int getNanoseconds() {
        return this.m_fraction * 1000;
    }
}

