/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import io.trino.client.Column;
import io.trino.client.JsonQueryData;
import io.trino.client.JsonResultRows;
import io.trino.client.OkHttpSegmentLoader;
import io.trino.client.QueryData;
import io.trino.client.QueryDataDecoder;
import io.trino.client.QueryResults;
import io.trino.client.ResultRows;
import io.trino.client.TypedQueryData;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.EncodedQueryData;
import io.trino.client.spooling.InlineSegment;
import io.trino.client.spooling.Segment;
import io.trino.client.spooling.SegmentLoader;
import io.trino.client.spooling.SpooledSegment;
import io.trino.client.spooling.encoding.QueryDataDecoders;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class ResultRowsDecoder
implements AutoCloseable {
    private final SegmentLoader loader;
    private QueryDataDecoder decoder;

    public ResultRowsDecoder() {
        this(new OkHttpSegmentLoader());
    }

    public ResultRowsDecoder(SegmentLoader loader) {
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    private void setEncoding(List<Column> columns, String encoding) {
        if (this.decoder != null) {
            Preconditions.checkState((boolean)this.decoder.encoding().equals(encoding), (String)"Decoder is configured for encoding %s but got %s", (Object)this.decoder.encoding(), (Object)encoding);
        } else {
            Preconditions.checkState((!columns.isEmpty() ? 1 : 0) != 0, (Object)"Columns must be set when decoding data");
            this.decoder = QueryDataDecoders.get(encoding).create(columns, DataAttributes.empty());
        }
    }

    public ResultRows toRows(QueryResults results) {
        if (results == null || results.getData() == null) {
            return ResultRows.NULL_ROWS;
        }
        return this.toRows(results.getColumns(), results.getData());
    }

    public ResultRows toRows(List<Column> columns, QueryData data) {
        if (data == null || data.isNull()) {
            return ResultRows.NULL_ROWS;
        }
        Verify.verify((columns != null && !columns.isEmpty() ? 1 : 0) != 0, (String)"Columns must be set when decoding data", (Object[])new Object[0]);
        if (data instanceof TypedQueryData) {
            TypedQueryData rawData = (TypedQueryData)data;
            if (rawData.isNull()) {
                return ResultRows.NULL_ROWS;
            }
            return () -> rawData.getIterable().iterator();
        }
        if (data instanceof JsonQueryData) {
            JsonQueryData jsonData = (JsonQueryData)data;
            if (jsonData.isNull()) {
                return ResultRows.NULL_ROWS;
            }
            return () -> JsonResultRows.forJsonParser(jsonData.getJsonParser(), columns).iterator();
        }
        if (data instanceof EncodedQueryData) {
            EncodedQueryData encodedData = (EncodedQueryData)data;
            this.setEncoding(columns, encodedData.getEncoding());
            return ResultRowsDecoder.concat(Iterables.transform(encodedData.getSegments(), this::segmentToRows));
        }
        throw new UnsupportedOperationException("Unsupported data type: " + data.getClass().getName());
    }

    private ResultRows segmentToRows(Segment segment) {
        if (segment instanceof InlineSegment) {
            InlineSegment inlineSegment = (InlineSegment)segment;
            try {
                return this.decoder.decode(new ByteArrayInputStream(inlineSegment.getData()), inlineSegment.getMetadata());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (segment instanceof SpooledSegment) {
            SpooledSegment spooledSegment = (SpooledSegment)segment;
            try {
                InputStream stream = this.loader.load(spooledSegment);
                return this.decoder.decode(stream, spooledSegment.getMetadata());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("Unsupported segment type: " + segment.getClass().getName());
    }

    public Optional<String> getEncoding() {
        return Optional.ofNullable(this.decoder).map(QueryDataDecoder::encoding);
    }

    @Override
    public void close() throws Exception {
        this.loader.close();
    }

    @SuppressModernizer
    private static ResultRows concat(Iterable<ResultRows> resultRows) {
        return ResultRows.fromIterableRows(Iterables.concat((Iterable)Iterables.filter(resultRows, rows -> !rows.isNull())));
    }
}

