/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.kerberos;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import io.trino.client.ClientException;
import io.trino.client.auth.kerberos.GSSContextProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import javax.security.auth.login.LoginException;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class SpnegoHandler
implements Interceptor,
Authenticator {
    private static final String NEGOTIATE = "Negotiate";
    private final String servicePrincipalPattern;
    private final String remoteServiceName;
    private final boolean useCanonicalHostname;
    private final GSSContextProvider contextProvider;

    public SpnegoHandler(String servicePrincipalPattern, String remoteServiceName, boolean useCanonicalHostname, GSSContextProvider contextProvider) {
        this.servicePrincipalPattern = Objects.requireNonNull(servicePrincipalPattern, "servicePrincipalPattern is null");
        this.remoteServiceName = Objects.requireNonNull(remoteServiceName, "remoteServiceName is null");
        this.useCanonicalHostname = useCanonicalHostname;
        this.contextProvider = Objects.requireNonNull(contextProvider, "subjectProvider is null");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            return chain.proceed(this.authenticate(chain.request()));
        }
        catch (ClientException ignored) {
            return chain.proceed(chain.request());
        }
    }

    public Request authenticate(Route route, Response response) {
        if (response.request().headers("Authorization").stream().anyMatch(SpnegoHandler::isNegotiate) || response.headers("WWW-Authenticate").stream().noneMatch(SpnegoHandler::isNegotiate)) {
            return null;
        }
        return this.authenticate(response.request());
    }

    private static boolean isNegotiate(String value) {
        return ((String)Splitter.on((CharMatcher)CharMatcher.whitespace()).split((CharSequence)value).iterator().next()).equalsIgnoreCase(NEGOTIATE);
    }

    private Request authenticate(Request request) {
        String hostName = request.url().host();
        String principal = SpnegoHandler.makeServicePrincipal(this.servicePrincipalPattern, this.remoteServiceName, hostName, this.useCanonicalHostname);
        byte[] token = this.generateToken(principal);
        String credential = "Negotiate " + Base64.getEncoder().encodeToString(token);
        return request.newBuilder().header("Authorization", credential).build();
    }

    private byte[] generateToken(String servicePrincipal) {
        GSSContext context = null;
        try {
            context = this.contextProvider.getContext(servicePrincipal);
            byte[] token = context.initSecContext(new byte[0], 0, 0);
            if (token == null) {
                throw new LoginException("No token generated from GSS context");
            }
            byte[] byArray = token;
            return byArray;
        }
        catch (LoginException | GSSException e) {
            throw new ClientException(String.format("Kerberos error for [%s]: %s", servicePrincipal, e.getMessage()), e);
        }
        finally {
            try {
                if (context != null) {
                    context.dispose();
                }
            }
            catch (GSSException gSSException) {}
        }
    }

    private static String makeServicePrincipal(String servicePrincipalPattern, String serviceName, String hostName, boolean useCanonicalHostname) {
        String serviceHostName = hostName;
        if (useCanonicalHostname) {
            serviceHostName = SpnegoHandler.canonicalizeServiceHostName(hostName);
        }
        return servicePrincipalPattern.replaceAll("\\$\\{SERVICE}", serviceName).replaceAll("\\$\\{HOST}", serviceHostName.toLowerCase(Locale.US));
    }

    private static String canonicalizeServiceHostName(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            String fullHostName = "localhost".equalsIgnoreCase(address.getHostName()) ? InetAddress.getLocalHost().getCanonicalHostName() : address.getCanonicalHostName();
            if (fullHostName.equalsIgnoreCase("localhost")) {
                throw new ClientException("Fully qualified name of localhost should not resolve to 'localhost'. System configuration error?");
            }
            return fullHostName;
        }
        catch (UnknownHostException e) {
            throw new ClientException("Failed to resolve host: " + hostName, e);
        }
    }
}

