/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.encoding.CompressedQueryDataDecoder;
import io.trino.client.spooling.encoding.DecompressionUtils;
import java.io.IOException;

public class Lz4QueryDataDecoder
extends CompressedQueryDataDecoder {
    public Lz4QueryDataDecoder(QueryDataDecoder delegate) {
        super(delegate);
    }

    @Override
    void decompress(byte[] input, byte[] output) throws IOException {
        int decompressedSize = DecompressionUtils.decompressLZ4(input, output);
        if (decompressedSize != output.length) {
            throw new IOException(String.format("Decompressed size does not match expected segment size, expected %d, got %d", decompressedSize, output.length));
        }
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+lz4";
    }
}

