/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampTzMicrosValueWriter
extends PrimitiveValueWriter {
    public TimestampTzMicrosValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
    }

    @Override
    public void write(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (mayHaveNull && block.isNull(i)) continue;
            long micros = TimestampTzMicrosValueWriter.toMicros((LongTimestampWithTimeZone)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.getObject(block, i));
            valuesWriter.writeLong(micros);
            statistics.updateStats(micros);
        }
    }

    private static long toMicros(LongTimestampWithTimeZone timestamp) {
        return timestamp.getEpochMillis() * 1000L + (long)Timestamps.roundDiv((int)timestamp.getPicosOfMilli(), (long)1000000L);
    }
}

