/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.httpquery;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.JsonBodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.httpquery.ForHttpEventListener;
import io.trino.plugin.httpquery.HttpEventListenerConfig;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HttpEventListener
implements EventListener {
    private final Logger log = Logger.get(HttpEventListener.class);
    private final LifeCycleManager lifecycleManager;
    private final JsonCodec<QueryCompletedEvent> queryCompletedEventJsonCodec;
    private final JsonCodec<QueryCreatedEvent> queryCreatedEventJsonCodec;
    private final JsonCodec<SplitCompletedEvent> splitCompletedEventJsonCodec;
    private final HttpClient client;
    private final boolean logCreated;
    private final boolean logCompleted;
    private final boolean logSplit;
    private final int retryCount;
    private final Duration retryDelay;
    private final Duration maxDelay;
    private final double backoffBase;
    private final Map<String, String> httpHeaders;
    private final URI ingestUri;
    private final ScheduledExecutorService executor;

    @Inject
    public HttpEventListener(LifeCycleManager lifecycleManager, JsonCodec<QueryCompletedEvent> queryCompletedEventJsonCodec, JsonCodec<QueryCreatedEvent> queryCreatedEventJsonCodec, JsonCodec<SplitCompletedEvent> splitCompletedEventJsonCodec, HttpEventListenerConfig config, @ForHttpEventListener HttpClient httpClient) {
        this.lifecycleManager = Objects.requireNonNull(lifecycleManager, "lifecycleManager is null");
        Objects.requireNonNull(config, "http event listener config is null");
        this.client = Objects.requireNonNull(httpClient, "http event listener http client is null");
        this.queryCompletedEventJsonCodec = Objects.requireNonNull(queryCompletedEventJsonCodec, "queryCompletedEventJsonCodec is null");
        this.queryCreatedEventJsonCodec = Objects.requireNonNull(queryCreatedEventJsonCodec, "queryCreatedEventJsonCodec is null");
        this.splitCompletedEventJsonCodec = Objects.requireNonNull(splitCompletedEventJsonCodec, "splitCompletedEventJsonCodec is null");
        this.logCreated = config.getLogCreated();
        this.logCompleted = config.getLogCompleted();
        this.logSplit = config.getLogSplit();
        this.retryCount = config.getRetryCount();
        this.retryDelay = config.getRetryDelay();
        this.maxDelay = config.getMaxDelay();
        this.backoffBase = config.getBackoffBase();
        this.httpHeaders = ImmutableMap.copyOf(config.getHttpHeaders());
        try {
            this.ingestUri = new URI(config.getIngestUri());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Ingest URI %s for HTTP event listener is not valid", config.getIngestUri()), e);
        }
        this.executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"http-event-listener-%s"));
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        if (this.logCreated) {
            this.sendLog((BodyGenerator)JsonBodyGenerator.jsonBodyGenerator(this.queryCreatedEventJsonCodec, (Object)queryCreatedEvent), queryCreatedEvent.getMetadata().getQueryId());
        }
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        if (this.logCompleted) {
            this.sendLog((BodyGenerator)JsonBodyGenerator.jsonBodyGenerator(this.queryCompletedEventJsonCodec, (Object)queryCompletedEvent), queryCompletedEvent.getMetadata().getQueryId());
        }
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        if (this.logSplit) {
            this.sendLog((BodyGenerator)JsonBodyGenerator.jsonBodyGenerator(this.splitCompletedEventJsonCodec, (Object)splitCompletedEvent), splitCompletedEvent.getQueryId());
        }
    }

    private void sendLog(BodyGenerator eventBodyGenerator, String queryId) {
        Request request = Request.Builder.preparePost().addHeaders((Multimap)Multimaps.forMap(this.httpHeaders)).addHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setUri(this.ingestUri).setBodyGenerator(eventBodyGenerator).build();
        this.attemptToSend(request, 0, Duration.valueOf((String)"0s"), queryId);
    }

    private void attemptToSend(final Request request, final int attempt, final Duration delay, final String queryId) {
        this.executor.schedule(() -> Futures.addCallback((ListenableFuture)this.client.executeAsync(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler()), (FutureCallback)new FutureCallback<StatusResponseHandler.StatusResponse>(this){
            final /* synthetic */ HttpEventListener this$0;
            {
                this.this$0 = this$0;
            }

            public void onSuccess(StatusResponseHandler.StatusResponse result) {
                Verify.verify((result != null ? 1 : 0) != 0);
                if (this.this$0.shouldRetry(result)) {
                    if (attempt < this.this$0.retryCount) {
                        Duration nextDelay = this.this$0.nextDelay(delay);
                        int nextAttempt = attempt + 1;
                        this.this$0.log.warn("QueryId = \"%s\", attempt = %d/%d, URL = %s | Ingest server responded with code %d, will retry after approximately %d seconds", new Object[]{queryId, attempt + 1, this.this$0.retryCount + 1, request.getUri().toString(), result.getStatusCode(), nextDelay.roundTo(TimeUnit.SECONDS)});
                        this.this$0.attemptToSend(request, nextAttempt, nextDelay, queryId);
                    } else {
                        this.this$0.log.error("QueryId = \"%s\", attempt = %d/%d, URL = %s | Ingest server responded with code %d, fatal error", new Object[]{queryId, attempt + 1, this.this$0.retryCount + 1, request.getUri().toString(), result.getStatusCode()});
                    }
                } else {
                    this.this$0.log.debug("QueryId = \"%s\", attempt = %d/%d, URL = %s | Query event delivered successfully", new Object[]{queryId, attempt + 1, this.this$0.retryCount + 1, request.getUri().toString()});
                }
            }

            public void onFailure(Throwable t) {
                if (attempt < this.this$0.retryCount) {
                    Duration nextDelay = this.this$0.nextDelay(delay);
                    int nextAttempt = attempt + 1;
                    this.this$0.log.warn(t, "QueryId = \"%s\", attempt = %d/%d, URL = %s | Sending event caused an exception, will retry after %d seconds", new Object[]{queryId, attempt + 1, this.this$0.retryCount + 1, request.getUri().toString(), nextDelay.roundTo(TimeUnit.SECONDS)});
                    this.this$0.attemptToSend(request, nextAttempt, nextDelay, queryId);
                } else {
                    this.this$0.log.error(t, "QueryId = \"%s\", attempt = %d/%d, URL = %s | Error sending HTTP request", new Object[]{queryId, attempt + 1, this.this$0.retryCount + 1, request.getUri().toString()});
                }
            }
        }, (Executor)this.executor), (long)delay.getValue(), delay.getUnit());
    }

    private boolean shouldRetry(StatusResponseHandler.StatusResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode < 200) {
            return false;
        }
        if (200 <= statusCode && statusCode < 300) {
            return false;
        }
        if (300 <= statusCode && statusCode <= 400) {
            return false;
        }
        return 400 > statusCode || statusCode >= 500 || statusCode == 408 || statusCode == 429;
    }

    private Duration nextDelay(Duration delay) {
        if (delay.compareTo(Duration.valueOf((String)"0s")) == 0) {
            return this.retryDelay;
        }
        Duration newDuration = Duration.succinctDuration((double)(delay.getValue(TimeUnit.SECONDS) * this.backoffBase), (TimeUnit)TimeUnit.SECONDS);
        if (newDuration.compareTo(this.maxDelay) > 0) {
            return this.maxDelay;
        }
        return newDuration;
    }

    public void shutdown() {
        this.lifecycleManager.stop();
    }
}

