/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.httpquery;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.plugin.httpquery.ForHttpEventListener;
import io.trino.plugin.httpquery.HttpEventListener;
import io.trino.plugin.httpquery.HttpEventListenerConfig;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.EventListenerFactory;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import java.util.Map;

public class HttpEventListenerFactory
implements EventListenerFactory {
    public String getName() {
        return "http";
    }

    public EventListener create(Map<String, String> config, EventListenerFactory.EventListenerContext context) {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), binder -> {
            binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
            binder.bind(Tracer.class).toInstance((Object)context.getTracer());
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryCompletedEvent.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryCreatedEvent.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(SplitCompletedEvent.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(HttpEventListenerConfig.class);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("http-event-listener", ForHttpEventListener.class);
            binder.bind(HttpEventListener.class).in(Scopes.SINGLETON);
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (EventListener)injector.getInstance(HttpEventListener.class);
    }
}

