/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.transports.EventTransformer;
import io.openlineage.client.transports.TransformConfig;
import io.openlineage.client.transports.TransformTransportException;
import io.openlineage.client.transports.Transport;
import io.openlineage.client.transports.TransportResolver;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformTransport
extends Transport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransformTransport.class);
    private final Transport transport;
    private final EventTransformer transformer;

    public TransformTransport(@NonNull TransformConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.transport = TransportResolver.resolveTransportByConfig(config.getTransport());
        this.transformer = this.initializeTransformClass(config);
    }

    public TransformTransport(@NonNull TransformConfig config, Transport transport) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.transport = transport;
        this.transformer = this.initializeTransformClass(config);
    }

    private EventTransformer initializeTransformClass(TransformConfig config) {
        try {
            Class<?> transformerClass = Class.forName(config.getTransformerClass());
            EventTransformer instance = (EventTransformer)transformerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            instance.initialize(config.getTransformerProperties());
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new TransformTransportException("Cannot find transformer class", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TransformTransportException("Cannot instantiate transformer class", e);
        }
        catch (ClassCastException e) {
            throw new TransformTransportException("Transform class not an EventTransformer", e);
        }
        catch (Exception e) {
            throw new TransformTransportException("Error initializing transformer class", e);
        }
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        OpenLineage.RunEvent updatedRunEvent;
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        try {
            updatedRunEvent = this.transformer.transform(runEvent);
        }
        catch (Exception e) {
            throw new TransformTransportException("Error transforming RunEvent", e);
        }
        if (updatedRunEvent == null) {
            throw new TransformTransportException("Transformed RunEvent is null, not emitting");
        }
        this.transport.emit(updatedRunEvent);
    }

    @Override
    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        OpenLineage.DatasetEvent updatedDatasetEvent;
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        try {
            updatedDatasetEvent = this.transformer.transform(datasetEvent);
        }
        catch (Exception e) {
            throw new TransformTransportException("Error transforming DatasetEvent", e);
        }
        if (updatedDatasetEvent == null) {
            throw new TransformTransportException("Transformed DatasetEvent is null, not emitting");
        }
        this.transport.emit(updatedDatasetEvent);
    }

    @Override
    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        OpenLineage.JobEvent updatedJobEvent;
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        try {
            updatedJobEvent = this.transformer.transform(jobEvent);
        }
        catch (Exception e) {
            throw new TransformTransportException("Error transforming JobEvent", e);
        }
        if (updatedJobEvent == null) {
            throw new TransformTransportException("Transformed JobEvent is null, not emitting");
        }
        this.transport.emit(updatedJobEvent);
    }

    @Override
    public void close() throws Exception {
        this.transport.close();
    }

    @Generated
    public Transport getTransport() {
        return this.transport;
    }

    @Generated
    public EventTransformer getTransformer() {
        return this.transformer;
    }
}

