/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.protocol;

import io.airlift.drift.protocol.TTransport;
import io.airlift.drift.protocol.TTransportException;

public class TMemoryBuffer
implements TTransport {
    private byte[] data;
    private int head;
    private int tail;

    public TMemoryBuffer(int initialSize) {
        this.data = new byte[Math.max(initialSize, 16)];
    }

    @Override
    public void read(byte[] buf, int off, int len) throws TTransportException {
        if (this.head - this.tail < len) {
            throw new TTransportException("Too few bytes in buffer");
        }
        System.arraycopy(this.data, this.tail, buf, off, len);
        this.tail += len;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        int available = this.data.length - this.head;
        if (available < len) {
            int need = len - available - this.tail;
            byte[] temp = new byte[Math.max(this.data.length * 2, need)];
            System.arraycopy(this.data, this.tail, temp, 0, this.head - this.tail);
            this.data = temp;
            this.head -= this.tail;
            this.tail = 0;
        }
        System.arraycopy(buf, off, this.data, this.head, len);
        this.head += len;
    }
}

