/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcReader;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class NameBasedFieldMapper
implements OrcReader.FieldMapper {
    private final Map<String, OrcColumn> nestedColumns;

    private NameBasedFieldMapper(Map<String, OrcColumn> nestedColumns) {
        this.nestedColumns = Objects.requireNonNull(nestedColumns, "nestedColumns is null");
    }

    @Override
    public OrcColumn get(String fieldName) {
        return this.nestedColumns.get(fieldName);
    }

    public static OrcReader.FieldMapper create(OrcColumn column) {
        Objects.requireNonNull(column, "column is null");
        ImmutableMap nestedColumns = Maps.uniqueIndex(column.getNestedColumns(), field -> field.getColumnName().toLowerCase(Locale.ENGLISH));
        return new NameBasedFieldMapper((Map<String, OrcColumn>)nestedColumns);
    }
}

