/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.metadata;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.parquet.schema.MessageType;

public final class FileMetadata {
    private final MessageType schema;
    private final Map<String, String> keyValueMetaData;
    private final String createdBy;

    public FileMetadata(MessageType schema, Map<String, String> keyValueMetaData, String createdBy) {
        this.schema = Objects.requireNonNull(schema, "schema cannot be null");
        this.keyValueMetaData = Collections.unmodifiableMap(Objects.requireNonNull(keyValueMetaData, "keyValueMetaData cannot be null"));
        this.createdBy = createdBy;
    }

    public MessageType getSchema() {
        return this.schema;
    }

    public String toString() {
        return "FileMetaData{schema: " + String.valueOf(this.schema) + ", metadata: " + String.valueOf(this.keyValueMetaData) + "}";
    }

    public Map<String, String> getKeyValueMetaData() {
        return this.keyValueMetaData;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }
}

