/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.Field;
import io.trino.parquet.ParquetTypeUtils;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;

public final class ListColumnReader {
    private ListColumnReader() {
    }

    public static BlockPositions calculateCollectionOffsets(Field field, int[] definitionLevels, int[] repetitionLevels) {
        int maxDefinitionLevel = field.getDefinitionLevel();
        int maxElementRepetitionLevel = field.getRepetitionLevel() + 1;
        boolean required = field.isRequired();
        int offset = 0;
        IntArrayList offsets = new IntArrayList();
        offsets.add(offset);
        if (required) {
            int i = 0;
            while (i < definitionLevels.length) {
                if (definitionLevels[i] == maxDefinitionLevel) {
                    offsets.add(offset);
                } else if (definitionLevels[i] > maxDefinitionLevel) {
                    offsets.add(offset += ListColumnReader.getCollectionSize(repetitionLevels, maxElementRepetitionLevel, i + 1));
                }
                i = ListColumnReader.getNextCollectionStartIndex(repetitionLevels, maxElementRepetitionLevel, i);
            }
            return new BlockPositions(Optional.empty(), offsets.toIntArray());
        }
        BooleanArrayList collectionIsNull = new BooleanArrayList();
        int nullValuesCount = 0;
        int i = 0;
        while (i < definitionLevels.length) {
            if (definitionLevels[i] >= maxDefinitionLevel - 1) {
                boolean isNull = ParquetTypeUtils.isOptionalFieldValueNull(definitionLevels[i], maxDefinitionLevel);
                collectionIsNull.add(isNull);
                nullValuesCount += isNull ? 1 : 0;
                if (definitionLevels[i] > maxDefinitionLevel) {
                    offset += ListColumnReader.getCollectionSize(repetitionLevels, maxElementRepetitionLevel, i + 1);
                }
                offsets.add(offset);
            }
            i = ListColumnReader.getNextCollectionStartIndex(repetitionLevels, maxElementRepetitionLevel, i);
        }
        if (nullValuesCount == 0) {
            return new BlockPositions(Optional.empty(), offsets.toIntArray());
        }
        return new BlockPositions(Optional.of(collectionIsNull.elements()), offsets.toIntArray());
    }

    private static int getNextCollectionStartIndex(int[] repetitionLevels, int maxRepetitionLevel, int elementIndex) {
        while (ListColumnReader.hasMoreElements(repetitionLevels, ++elementIndex) && !ListColumnReader.isCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, elementIndex)) {
        }
        return elementIndex;
    }

    private static int getCollectionSize(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        int size = 1;
        while (ListColumnReader.hasMoreElements(repetitionLevels, nextIndex) && !ListColumnReader.isCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, nextIndex)) {
            if (repetitionLevels[nextIndex] <= maxRepetitionLevel) {
                ++size;
            }
            ++nextIndex;
        }
        return size;
    }

    private static boolean isCollectionBeginningMarker(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        return repetitionLevels[nextIndex] < maxRepetitionLevel;
    }

    private static boolean hasMoreElements(int[] repetitionLevels, int nextIndex) {
        return nextIndex < repetitionLevels.length;
    }

    public record BlockPositions(Optional<boolean[]> isNull, int[] offsets) {
    }
}

