/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.trino.parquet.reader.flat.BitPackingUtils;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorBitPackingUtils {
    private static final ByteVector MASK_1 = ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (long)1L);
    private static final ByteVector LSHR_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7}, (int)0);

    private VectorBitPackingUtils() {
    }

    public static int vectorUnpackAndInvert8(boolean[] values, int offset, byte packedByte) {
        ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (byte)packedByte).lanewise(VectorOperators.LSHR, (Vector)LSHR_BYTE_VECTOR).and((Vector)MASK_1).lanewise(VectorOperators.NOT).intoBooleanArray(values, offset);
        return BitPackingUtils.bitCount(packedByte);
    }

    public static void vectorUnpack8FromByte(byte[] values, int offset, byte packedByte) {
        ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (byte)packedByte).lanewise(VectorOperators.LSHR, (Vector)LSHR_BYTE_VECTOR).and((Vector)MASK_1).intoArray(values, offset);
    }
}

