/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import io.trino.parquet.ParquetMetadataConverter;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.FieldRepetitionType;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.TypeVisitor;

class MessageTypeConverter {
    private MessageTypeConverter() {
    }

    static List<SchemaElement> toParquetSchema(MessageType schema) {
        ArrayList<SchemaElement> result = new ArrayList<SchemaElement>();
        MessageTypeConverter.addToList(result, (Type)schema);
        return result;
    }

    private static void addToList(final List<SchemaElement> result, Type field) {
        field.accept(new TypeVisitor(){

            public void visit(PrimitiveType primitiveType) {
                SchemaElement element = new SchemaElement(primitiveType.getName());
                element.setRepetition_type(MessageTypeConverter.toParquetRepetition(primitiveType.getRepetition()));
                element.setType(MessageTypeConverter.getType(primitiveType.getPrimitiveTypeName()));
                if (primitiveType.getOriginalType() != null) {
                    element.setConverted_type(MessageTypeConverter.getConvertedType(primitiveType.getOriginalType()));
                }
                if (primitiveType.getLogicalTypeAnnotation() != null) {
                    element.setLogicalType(ParquetMetadataConverter.convertToLogicalType(primitiveType.getLogicalTypeAnnotation()));
                }
                if (primitiveType.getDecimalMetadata() != null) {
                    element.setPrecision(primitiveType.getDecimalMetadata().getPrecision());
                    element.setScale(primitiveType.getDecimalMetadata().getScale());
                }
                if (primitiveType.getTypeLength() > 0) {
                    element.setType_length(primitiveType.getTypeLength());
                }
                if (primitiveType.getId() != null) {
                    element.setField_id(primitiveType.getId().intValue());
                }
                result.add(element);
            }

            public void visit(MessageType messageType) {
                SchemaElement element = new SchemaElement(messageType.getName());
                if (messageType.getId() != null) {
                    element.setField_id(messageType.getId().intValue());
                }
                this.visitChildren(result, messageType.asGroupType(), element);
            }

            public void visit(GroupType groupType) {
                SchemaElement element = new SchemaElement(groupType.getName());
                element.setRepetition_type(MessageTypeConverter.toParquetRepetition(groupType.getRepetition()));
                if (groupType.getOriginalType() != null) {
                    element.setConverted_type(MessageTypeConverter.getConvertedType(groupType.getOriginalType()));
                }
                if (groupType.getLogicalTypeAnnotation() != null) {
                    element.setLogicalType(ParquetMetadataConverter.convertToLogicalType(groupType.getLogicalTypeAnnotation()));
                }
                if (groupType.getId() != null) {
                    element.setField_id(groupType.getId().intValue());
                }
                this.visitChildren(result, groupType, element);
            }

            private void visitChildren(List<SchemaElement> result2, GroupType groupType, SchemaElement element) {
                element.setNum_children(groupType.getFieldCount());
                result2.add(element);
                for (Type field : groupType.getFields()) {
                    MessageTypeConverter.addToList(result2, field);
                }
            }
        });
    }

    private static FieldRepetitionType toParquetRepetition(Type.Repetition repetition) {
        return FieldRepetitionType.valueOf((String)repetition.name());
    }

    private static org.apache.parquet.format.Type getType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT64: {
                return org.apache.parquet.format.Type.INT64;
            }
            case INT32: {
                return org.apache.parquet.format.Type.INT32;
            }
            case BOOLEAN: {
                return org.apache.parquet.format.Type.BOOLEAN;
            }
            case BINARY: {
                return org.apache.parquet.format.Type.BYTE_ARRAY;
            }
            case FLOAT: {
                return org.apache.parquet.format.Type.FLOAT;
            }
            case DOUBLE: {
                return org.apache.parquet.format.Type.DOUBLE;
            }
            case INT96: {
                return org.apache.parquet.format.Type.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return org.apache.parquet.format.Type.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown primitive type " + String.valueOf(type));
    }

    private static ConvertedType getConvertedType(OriginalType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case OriginalType.UTF8 -> ConvertedType.UTF8;
            case OriginalType.MAP -> ConvertedType.MAP;
            case OriginalType.MAP_KEY_VALUE -> ConvertedType.MAP_KEY_VALUE;
            case OriginalType.LIST -> ConvertedType.LIST;
            case OriginalType.ENUM -> ConvertedType.ENUM;
            case OriginalType.DECIMAL -> ConvertedType.DECIMAL;
            case OriginalType.DATE -> ConvertedType.DATE;
            case OriginalType.TIME_MICROS -> ConvertedType.TIME_MICROS;
            case OriginalType.TIME_MILLIS -> ConvertedType.TIME_MILLIS;
            case OriginalType.TIMESTAMP_MILLIS -> ConvertedType.TIMESTAMP_MILLIS;
            case OriginalType.TIMESTAMP_MICROS -> ConvertedType.TIMESTAMP_MICROS;
            case OriginalType.INTERVAL -> ConvertedType.INTERVAL;
            case OriginalType.INT_8 -> ConvertedType.INT_8;
            case OriginalType.INT_16 -> ConvertedType.INT_16;
            case OriginalType.INT_32 -> ConvertedType.INT_32;
            case OriginalType.INT_64 -> ConvertedType.INT_64;
            case OriginalType.UINT_8 -> ConvertedType.UINT_8;
            case OriginalType.UINT_16 -> ConvertedType.UINT_16;
            case OriginalType.UINT_32 -> ConvertedType.UINT_32;
            case OriginalType.UINT_64 -> ConvertedType.UINT_64;
            case OriginalType.JSON -> ConvertedType.JSON;
            case OriginalType.BSON -> ConvertedType.BSON;
        };
    }
}

