/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.plugin.base.io.ChunkedSliceOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public interface ParquetDataOutput {
    public static ParquetDataOutput createDataOutput(final Slice slice) {
        Objects.requireNonNull(slice, "slice is null");
        return new ParquetDataOutput(){

            @Override
            public int size() {
                return slice.length();
            }

            @Override
            public void writeData(SliceOutput sliceOutput) {
                sliceOutput.writeBytes(slice);
            }
        };
    }

    public static ParquetDataOutput createDataOutput(final ChunkedSliceOutput chunkedSliceOutput) {
        Objects.requireNonNull(chunkedSliceOutput, "chunkedSliceOutput is null");
        return new ParquetDataOutput(){

            @Override
            public int size() {
                return chunkedSliceOutput.size();
            }

            @Override
            public void writeData(SliceOutput sliceOutput) {
                chunkedSliceOutput.getSlices().forEach(arg_0 -> ((SliceOutput)sliceOutput).writeBytes(arg_0));
            }
        };
    }

    public static ParquetDataOutput createDataOutput(final ByteArrayOutputStream byteArrayOutputStream) {
        Objects.requireNonNull(byteArrayOutputStream, "byteArrayOutputStream is null");
        return new ParquetDataOutput(){

            @Override
            public int size() {
                return byteArrayOutputStream.size();
            }

            @Override
            public void writeData(SliceOutput sliceOutput) {
                try {
                    byteArrayOutputStream.writeTo((OutputStream)sliceOutput);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public int size();

    public void writeData(SliceOutput var1);
}

