/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ClassGenerator;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.OpCode;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.control.TryCatch;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class FastMethodHandleProxies {
    private static final AtomicLong CLASS_ID = new AtomicLong();

    private FastMethodHandleProxies() {
    }

    public static <T> T asInterfaceInstance(Class<T> type, MethodHandle target) {
        String className = "$gen." + type.getName() + "_" + CLASS_ID.incrementAndGet();
        return FastMethodHandleProxies.asInterfaceInstance(className, type, target);
    }

    public static <T> T asInterfaceInstance(String className, Class<T> type, MethodHandle target) {
        Preconditions.checkArgument((type.isInterface() && Modifier.isPublic(type.getModifiers()) ? 1 : 0) != 0, (String)"not a public interface: %s", (Object)type.getName());
        ClassDefinition classDefinition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL, Access.SYNTHETIC), ParameterizedType.typeFromJavaClassName(className), ParameterizedType.type(Object.class), ParameterizedType.type(type));
        classDefinition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        Method method = FastMethodHandleProxies.getSingleAbstractMethod(type);
        Class<?>[] parameterTypes = method.getParameterTypes();
        MethodHandle adaptedTarget = target.asType(MethodType.methodType(method.getReturnType(), parameterTypes));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters.add(Parameter.arg("arg" + i, parameterTypes[i]));
        }
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a(Access.PUBLIC), method.getName(), ParameterizedType.type(method.getReturnType()), parameters);
        BytecodeNode invocation = BytecodeExpressions.invokeDynamic(Bootstrap.BOOTSTRAP_METHOD, (Iterable<? extends Object>)ImmutableList.of(), method.getName(), method.getReturnType(), parameters).ret();
        ImmutableList.Builder exceptionTypes = ImmutableList.builder();
        exceptionTypes.add((Object[])new ParameterizedType[]{ParameterizedType.type(RuntimeException.class), ParameterizedType.type(Error.class)});
        for (Class<?> exceptionType : method.getExceptionTypes()) {
            methodDefinition.addException(exceptionType.asSubclass(Throwable.class));
            exceptionTypes.add((Object)ParameterizedType.type(exceptionType));
        }
        BytecodeBlock throwUndeclared = new BytecodeBlock().newObject(UndeclaredThrowableException.class).append(OpCode.DUP_X1).swap().invokeConstructor(UndeclaredThrowableException.class, Throwable.class).throwObject();
        invocation = new TryCatch(invocation, (List<TryCatch.CatchBlock>)ImmutableList.of((Object)new TryCatch.CatchBlock(new BytecodeBlock().throwObject(), (List<ParameterizedType>)exceptionTypes.build()), (Object)new TryCatch.CatchBlock(throwUndeclared, (List<ParameterizedType>)ImmutableList.of())));
        methodDefinition.getBody().append(invocation);
        ClassLoader targetClassLoader = FastMethodHandleProxies.class.getClassLoader();
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(targetClassLoader, (Map<Long, MethodHandle>)ImmutableMap.of((Object)0L, (Object)adaptedTarget));
        Class<T> newClass = ClassGenerator.classGenerator(dynamicClassLoader).defineClass(classDefinition, type);
        try {
            return newClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Method getSingleAbstractMethod(Class<T> type) {
        return (Method)Arrays.stream(type.getMethods()).filter(method -> Modifier.isAbstract(method.getModifiers())).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getDeclaringClass() != Object.class).filter(FastMethodHandleProxies::notJavaObjectMethod).collect(MoreCollectors.onlyElement());
    }

    private static boolean notJavaObjectMethod(Method method) {
        return FastMethodHandleProxies.notMethodMatches(method, "toString", String.class, new Class[0]) && FastMethodHandleProxies.notMethodMatches(method, "hashCode", Integer.TYPE, new Class[0]) && FastMethodHandleProxies.notMethodMatches(method, "equals", Boolean.TYPE, Object.class);
    }

    private static boolean notMethodMatches(Method method, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return method.getParameterCount() != parameterTypes.length || method.getReturnType() != returnType || !name.equals(method.getName()) || !Arrays.equals(method.getParameterTypes(), parameterTypes);
    }

    public static final class Bootstrap {
        public static final Method BOOTSTRAP_METHOD;

        private Bootstrap() {
        }

        public static CallSite bootstrap(MethodHandles.Lookup callerLookup, String name, MethodType type) {
            DynamicClassLoader classLoader = (DynamicClassLoader)callerLookup.lookupClass().getClassLoader();
            return new ConstantCallSite(classLoader.getCallSiteBindings().get(0L));
        }

        static {
            try {
                BOOTSTRAP_METHOD = Bootstrap.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

