/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.control;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.control.FlowControl;
import io.airlift.bytecode.instruction.LabelNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.objectweb.asm.MethodVisitor;

public class TryCatch
implements FlowControl {
    private final String comment;
    private final BytecodeNode tryNode;
    private final List<CatchBlock> catchBlocks;

    public TryCatch(BytecodeNode tryNode, List<CatchBlock> catchBlocks) {
        this(null, tryNode, catchBlocks);
    }

    public TryCatch(String comment, BytecodeNode tryNode, List<CatchBlock> catchBlocks) {
        this.comment = comment;
        this.tryNode = Objects.requireNonNull(tryNode, "tryNode is null");
        this.catchBlocks = ImmutableList.copyOf((Collection)Objects.requireNonNull(catchBlocks, "catchBlocks is null"));
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public BytecodeNode getTryNode() {
        return this.tryNode;
    }

    public List<CatchBlock> getCatchBlocks() {
        return this.catchBlocks;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        int i;
        LabelNode tryStart = new LabelNode("tryStart");
        LabelNode tryEnd = new LabelNode("tryEnd");
        ArrayList<LabelNode> handlers = new ArrayList<LabelNode>();
        LabelNode done = new LabelNode("done");
        BytecodeBlock block = new BytecodeBlock();
        block.visitLabel(tryStart).append(this.tryNode).visitLabel(tryEnd).gotoLabel(done);
        for (i = 0; i < this.catchBlocks.size(); ++i) {
            BytecodeNode handlerBlock = this.catchBlocks.get(i).getHandler();
            LabelNode handler = new LabelNode("handler" + i);
            handlers.add(handler);
            block.visitLabel(handler).append(handlerBlock);
        }
        block.visitLabel(done);
        block.accept(visitor, generationContext);
        for (i = 0; i < this.catchBlocks.size(); ++i) {
            LabelNode handler = (LabelNode)handlers.get(i);
            List<ParameterizedType> exceptionTypes = this.catchBlocks.get(i).getExceptionTypes();
            for (ParameterizedType type : exceptionTypes) {
                visitor.visitTryCatchBlock(tryStart.getLabel(), tryEnd.getLabel(), handler.getLabel(), type.getClassName());
            }
            if (!exceptionTypes.isEmpty()) continue;
            visitor.visitTryCatchBlock(tryStart.getLabel(), tryEnd.getLabel(), handler.getLabel(), null);
        }
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return (List)Stream.concat(Stream.of(this.tryNode), this.catchBlocks.stream().map(CatchBlock::getHandler)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitTryCatch(parent, this);
    }

    public static class CatchBlock {
        private final BytecodeNode handler;
        private final List<ParameterizedType> exceptionTypes;

        public CatchBlock(BytecodeNode handler, List<ParameterizedType> exceptionTypes) {
            this.handler = Objects.requireNonNull(handler, "handler is null");
            this.exceptionTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(exceptionTypes, "exceptionTypes is null"));
        }

        public BytecodeNode getHandler() {
            return this.handler;
        }

        public List<ParameterizedType> getExceptionTypes() {
            return this.exceptionTypes;
        }
    }
}

