/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.objectweb.asm.Type;

public class Scope {
    private final Map<String, Variable> variables = new TreeMap<String, Variable>();
    private final Map<String, Variable> tempVariables = new TreeMap<String, Variable>();
    private final List<Variable> allVariables = new ArrayList<Variable>();
    private final Map<ParameterizedType, Deque<Variable>> releasedTempVariables = new HashMap<ParameterizedType, Deque<Variable>>();
    private final Variable thisVariable;
    private int nextTempVariableId;

    Scope(Optional<ParameterizedType> thisType, Iterable<Parameter> parameters) {
        if (thisType.isPresent()) {
            this.thisVariable = new Variable("this", thisType.get());
            this.variables.put("this", this.thisVariable);
            this.allVariables.add(this.thisVariable);
        } else {
            this.thisVariable = null;
        }
        for (Parameter parameter : parameters) {
            this.variables.put(parameter.getName(), parameter);
            this.allVariables.add(parameter);
        }
    }

    public List<Variable> getVariables() {
        return ImmutableList.copyOf(this.allVariables);
    }

    public Variable createTempVariable(Class<?> type) {
        Variable variable = new Variable("temp_" + this.nextTempVariableId, ParameterizedType.type(type));
        this.nextTempVariableId += Type.getType((String)ParameterizedType.type(type).getType()).getSize();
        this.tempVariables.put(variable.getName(), variable);
        this.allVariables.add(variable);
        return variable;
    }

    public Variable getOrCreateTempVariable(Class<?> type) {
        Deque<Variable> typeVariables = this.releasedTempVariables.get(ParameterizedType.type(type));
        if (typeVariables == null || typeVariables.isEmpty()) {
            return this.createTempVariable(type);
        }
        return typeVariables.pop();
    }

    public void releaseTempVariableForReuse(Variable tempVariable) {
        Objects.requireNonNull(tempVariable, "tempVariable is null");
        Preconditions.checkArgument((tempVariable == this.tempVariables.get(tempVariable.getName()) ? 1 : 0) != 0, (String)"invalid tempVariable release: %s", (Object)tempVariable);
        this.releasedTempVariables.computeIfAbsent(tempVariable.getType(), ignored -> new LinkedList()).push(tempVariable);
    }

    public Variable getTempVariable(String name) {
        Variable variable = this.tempVariables.get(name);
        Preconditions.checkArgument((variable != null ? 1 : 0) != 0, (String)"Temp variable '%s' not defined", (Object)name);
        return variable;
    }

    public Variable getThis() {
        Preconditions.checkState((this.thisVariable != null ? 1 : 0) != 0, (Object)"Static methods do not have a 'this' variable");
        return this.thisVariable;
    }

    public Variable getVariable(String name) {
        Variable variable = this.variables.get(name);
        Preconditions.checkArgument((variable != null ? 1 : 0) != 0, (String)"Variable '%s' not defined", (Object)name);
        return variable;
    }

    public Variable declareVariable(Class<?> type, String variableName) {
        return this.declareVariable(ParameterizedType.type(type), variableName);
    }

    public Variable declareVariable(ParameterizedType type, String variableName) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(variableName, "variableName is null");
        Preconditions.checkArgument((!this.variables.containsKey(variableName) ? 1 : 0) != 0, (String)"There is already a variable named %s", (Object)variableName);
        Preconditions.checkArgument((!variableName.equals("this") ? 1 : 0) != 0, (Object)"The 'this' variable can not be declared");
        Variable variable = new Variable(variableName, type);
        this.variables.put(variableName, variable);
        this.allVariables.add(variable);
        return variable;
    }

    public Variable declareVariable(String variableName, BytecodeBlock block, BytecodeExpression initialValue) {
        Variable variable = this.declareVariable(initialValue.getType(), variableName);
        block.append(variable.set(initialValue));
        return variable;
    }
}

