/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.pinot.segment.spi.index.IndexType;

public class FetchContext {
    private final UUID _fetchId;
    private final String _segmentName;
    private final Map<String, List<IndexType<?, ?, ?>>> _columnToIndexList;

    public FetchContext(UUID fetchId, String segmentName, Set<String> columns) {
        this._fetchId = fetchId;
        this._segmentName = segmentName;
        this._columnToIndexList = new HashMap();
        for (String column : columns) {
            this._columnToIndexList.put(column, null);
        }
    }

    public FetchContext(UUID fetchId, String segmentName, Map<String, List<IndexType<?, ?, ?>>> columnToIndexList) {
        this._fetchId = fetchId;
        this._segmentName = segmentName;
        this._columnToIndexList = columnToIndexList;
    }

    public UUID getFetchId() {
        return this._fetchId;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public Map<String, List<IndexType<?, ?, ?>>> getColumnToIndexList() {
        return this._columnToIndexList;
    }

    public boolean isEmpty() {
        return this._columnToIndexList.isEmpty();
    }
}

