/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class StatsCollectorConfig {
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final SegmentPartitionConfig _segmentPartitionConfig;
    private final Map<String, FieldConfig> _columnFieldConfigMap;

    public StatsCollectorConfig(TableConfig tableConfig, Schema schema, @Nullable SegmentPartitionConfig segmentPartitionConfig) {
        Preconditions.checkNotNull((Object)tableConfig);
        Preconditions.checkNotNull((Object)schema);
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._segmentPartitionConfig = segmentPartitionConfig;
        this._columnFieldConfigMap = new HashMap<String, FieldConfig>();
        if (tableConfig.getFieldConfigList() != null) {
            for (FieldConfig fieldConfig : tableConfig.getFieldConfigList()) {
                this._columnFieldConfigMap.put(fieldConfig.getName(), fieldConfig);
            }
        }
    }

    @Nullable
    public FieldSpec getFieldSpecForColumn(String column) {
        return this._schema.getFieldSpecFor(column);
    }

    @Nullable
    public String getPartitionFunctionName(String column) {
        if (this._segmentPartitionConfig == null) {
            return null;
        }
        return this._segmentPartitionConfig.getFunctionName(column);
    }

    public int getNumPartitions(String column) {
        return this._segmentPartitionConfig != null ? this._segmentPartitionConfig.getNumPartitions(column) : -1;
    }

    @Nullable
    public Map<String, String> getPartitionFunctionConfig(String column) {
        return this._segmentPartitionConfig != null ? this._segmentPartitionConfig.getFunctionConfig(column) : null;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    @Nullable
    public FieldConfig getFieldConfigForColumn(String column) {
        return this._columnFieldConfigMap.get(column);
    }
}

