/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SegmentNameUtils;

public class SimpleSegmentNameGenerator
implements SegmentNameGenerator {
    private final String _segmentNamePrefix;
    private final String _segmentNamePostfix;
    private final boolean _appendUUIDToSegmentName;
    private final boolean _excludeTimeInSegmentName;

    public SimpleSegmentNameGenerator(String segmentNamePrefix, @Nullable String segmentNamePostfix) {
        this(segmentNamePrefix, segmentNamePostfix, false, false);
    }

    public SimpleSegmentNameGenerator(String segmentNamePrefix, @Nullable String segmentNamePostfix, boolean appendUUIDToSegmentName, boolean excludeTimeInSegmentName) {
        Preconditions.checkArgument((segmentNamePrefix != null ? 1 : 0) != 0, (Object)"Missing segmentNamePrefix for SimpleSegmentNameGenerator");
        SegmentNameUtils.validatePartialOrFullSegmentName(segmentNamePrefix);
        if (segmentNamePostfix != null) {
            SegmentNameUtils.validatePartialOrFullSegmentName(segmentNamePostfix);
        }
        this._segmentNamePrefix = segmentNamePrefix;
        this._segmentNamePostfix = segmentNamePostfix;
        this._appendUUIDToSegmentName = appendUUIDToSegmentName;
        this._excludeTimeInSegmentName = excludeTimeInSegmentName;
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        if (this._excludeTimeInSegmentName) {
            return JOINER.join((Object)this._segmentNamePrefix, (Object)this._segmentNamePostfix, new Object[]{sequenceId >= 0 ? Integer.valueOf(sequenceId) : null, this._appendUUIDToSegmentName ? UUID.randomUUID().toString() : null});
        }
        if (minTimeValue != null) {
            SegmentNameUtils.validatePartialOrFullSegmentName(minTimeValue.toString());
        }
        if (maxTimeValue != null) {
            SegmentNameUtils.validatePartialOrFullSegmentName(maxTimeValue.toString());
        }
        return JOINER.join((Object)this._segmentNamePrefix, minTimeValue, new Object[]{maxTimeValue, this._segmentNamePostfix, sequenceId >= 0 ? Integer.valueOf(sequenceId) : null, this._appendUUIDToSegmentName ? UUID.randomUUID().toString() : null});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SimpleSegmentNameGenerator: tableName=").append(this._segmentNamePrefix);
        if (this._segmentNamePostfix != null) {
            stringBuilder.append(", segmentNamePostfix=").append(this._segmentNamePostfix);
        }
        stringBuilder.append(", appendUUIDToSegmentName=").append(this._appendUUIDToSegmentName);
        stringBuilder.append(", excludeTimeInSegmentName=").append(this._excludeTimeInSegmentName);
        return stringBuilder.toString();
    }
}

