/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.Intern;

public class DictionaryIndexConfig
extends IndexConfig {
    public static final DictionaryIndexConfig DEFAULT = new DictionaryIndexConfig(false, false, false, Intern.DISABLED);
    public static final DictionaryIndexConfig DISABLED = new DictionaryIndexConfig(true, false, false, Intern.DISABLED);
    private final boolean _onHeap;
    private final boolean _useVarLengthDictionary;
    private final Intern _intern;

    public DictionaryIndexConfig(Boolean onHeap, @Nullable Boolean useVarLengthDictionary) {
        this(onHeap, useVarLengthDictionary, null);
    }

    public DictionaryIndexConfig(Boolean onHeap, @Nullable Boolean useVarLengthDictionary, Intern intern) {
        this(false, onHeap, useVarLengthDictionary, intern);
    }

    @JsonCreator
    public DictionaryIndexConfig(@JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="onHeap") Boolean onHeap, @JsonProperty(value="useVarLengthDictionary") @Nullable Boolean useVarLengthDictionary, @JsonProperty(value="intern") @Nullable Intern intern) {
        super(disabled);
        if (intern != null) {
            Preconditions.checkState((intern.isDisabled() || Boolean.TRUE.equals(onHeap) ? 1 : 0) != 0, (Object)"Intern configs only work with on-heap dictionary");
        }
        this._onHeap = onHeap != null && onHeap != false;
        this._useVarLengthDictionary = Boolean.TRUE.equals(useVarLengthDictionary);
        this._intern = intern;
    }

    public static DictionaryIndexConfig disabled() {
        return DISABLED;
    }

    public boolean isOnHeap() {
        return this._onHeap;
    }

    public boolean getUseVarLengthDictionary() {
        return this._useVarLengthDictionary;
    }

    public Intern getIntern() {
        return this._intern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DictionaryIndexConfig that = (DictionaryIndexConfig)((Object)o);
        return this._onHeap == that._onHeap && this._useVarLengthDictionary == that._useVarLengthDictionary && Objects.equals(this._intern, that._intern);
    }

    public int hashCode() {
        return Objects.hash(this._onHeap, this._useVarLengthDictionary, this._intern);
    }

    public String toString() {
        if (this.isEnabled()) {
            String internStr = this._intern == null ? "null" : this._intern.toString();
            return "DictionaryIndexConfig{\"onHeap\":" + this._onHeap + ", \"useVarLengthDictionary\":" + this._useVarLengthDictionary + ", \"intern\":" + internStr + "}";
        }
        return "DictionaryIndexConfig{\"disabled\": true}";
    }
}

