/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.DictIdCompressionType;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.utils.DataSizeUtils;

public class ForwardIndexConfig
extends IndexConfig {
    public static final int DEFAULT_RAW_WRITER_VERSION = 2;
    public static final int DEFAULT_TARGET_MAX_CHUNK_SIZE_BYTES = 0x100000;
    public static final String DEFAULT_TARGET_MAX_CHUNK_SIZE = DataSizeUtils.fromBytes((long)0x100000L);
    public static final int DEFAULT_TARGET_DOCS_PER_CHUNK = 1000;
    public static final ForwardIndexConfig DISABLED = new ForwardIndexConfig(true, null, null, null, null, null, null, null);
    public static final ForwardIndexConfig DEFAULT = new Builder().build();
    @Nullable
    private final FieldConfig.CompressionCodec _compressionCodec;
    private final boolean _deriveNumDocsPerChunk;
    private final int _rawIndexWriterVersion;
    private final String _targetMaxChunkSize;
    private final int _targetMaxChunkSizeBytes;
    private final int _targetDocsPerChunk;
    @Nullable
    private final ChunkCompressionType _chunkCompressionType;
    @Nullable
    private final DictIdCompressionType _dictIdCompressionType;

    public ForwardIndexConfig(@Nullable Boolean disabled, @Nullable FieldConfig.CompressionCodec compressionCodec, @Nullable Boolean deriveNumDocsPerChunk, @Nullable Integer rawIndexWriterVersion, @Nullable String targetMaxChunkSize, @Nullable Integer targetDocsPerChunk) {
        block10: {
            block9: {
                super(disabled);
                this._deriveNumDocsPerChunk = Boolean.TRUE.equals(deriveNumDocsPerChunk);
                this._rawIndexWriterVersion = rawIndexWriterVersion == null ? 2 : rawIndexWriterVersion;
                this._compressionCodec = compressionCodec;
                if (targetMaxChunkSize != null && !this._deriveNumDocsPerChunk && this._rawIndexWriterVersion != 4) {
                    throw new IllegalStateException("targetMaxChunkSize should only be used when deriveNumDocsPerChunk is true or rawIndexWriterVersion is 4");
                }
                this._targetMaxChunkSizeBytes = targetMaxChunkSize == null ? 0x100000 : (int)DataSizeUtils.toBytes((String)targetMaxChunkSize);
                this._targetMaxChunkSize = targetMaxChunkSize == null ? DEFAULT_TARGET_MAX_CHUNK_SIZE : targetMaxChunkSize;
                int n = this._targetDocsPerChunk = targetDocsPerChunk == null ? 1000 : targetDocsPerChunk;
                if (compressionCodec == null) break block9;
                switch (compressionCodec) {
                    case PASS_THROUGH: 
                    case CLP: {
                        this._chunkCompressionType = ChunkCompressionType.PASS_THROUGH;
                        this._dictIdCompressionType = null;
                        break block10;
                    }
                    case SNAPPY: {
                        this._chunkCompressionType = ChunkCompressionType.SNAPPY;
                        this._dictIdCompressionType = null;
                        break block10;
                    }
                    case ZSTANDARD: {
                        this._chunkCompressionType = ChunkCompressionType.ZSTANDARD;
                        this._dictIdCompressionType = null;
                        break block10;
                    }
                    case LZ4: {
                        this._chunkCompressionType = ChunkCompressionType.LZ4;
                        this._dictIdCompressionType = null;
                        break block10;
                    }
                    case GZIP: {
                        this._chunkCompressionType = ChunkCompressionType.GZIP;
                        this._dictIdCompressionType = null;
                        break block10;
                    }
                    case MV_ENTRY_DICT: {
                        this._dictIdCompressionType = DictIdCompressionType.MV_ENTRY_DICT;
                        this._chunkCompressionType = null;
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported compression codec: " + compressionCodec);
                    }
                }
            }
            this._dictIdCompressionType = null;
            this._chunkCompressionType = null;
        }
    }

    @JsonCreator
    public ForwardIndexConfig(@JsonProperty(value="disabled") @Nullable Boolean disabled, @JsonProperty(value="compressionCodec") @Nullable FieldConfig.CompressionCodec compressionCodec, @Deprecated @JsonProperty(value="chunkCompressionType") @Nullable ChunkCompressionType chunkCompressionType, @Deprecated @JsonProperty(value="dictIdCompressionType") @Nullable DictIdCompressionType dictIdCompressionType, @JsonProperty(value="deriveNumDocsPerChunk") @Nullable Boolean deriveNumDocsPerChunk, @JsonProperty(value="rawIndexWriterVersion") @Nullable Integer rawIndexWriterVersion, @JsonProperty(value="targetMaxChunkSize") @Nullable String targetMaxChunkSizeBytes, @JsonProperty(value="targetDocsPerChunk") @Nullable Integer targetDocsPerChunk) {
        this(disabled, ForwardIndexConfig.getActualCompressionCodec(compressionCodec, chunkCompressionType, dictIdCompressionType), deriveNumDocsPerChunk, rawIndexWriterVersion, targetMaxChunkSizeBytes, targetDocsPerChunk);
    }

    public static FieldConfig.CompressionCodec getActualCompressionCodec(@Nullable FieldConfig.CompressionCodec compressionCodec, @Nullable ChunkCompressionType chunkCompressionType, @Nullable DictIdCompressionType dictIdCompressionType) {
        if (compressionCodec != null) {
            return compressionCodec;
        }
        if (chunkCompressionType != null && dictIdCompressionType != null) {
            throw new IllegalArgumentException("chunkCompressionType and dictIdCompressionType should not be used together");
        }
        if (chunkCompressionType != null) {
            switch (chunkCompressionType) {
                case PASS_THROUGH: {
                    return FieldConfig.CompressionCodec.PASS_THROUGH;
                }
                case SNAPPY: {
                    return FieldConfig.CompressionCodec.SNAPPY;
                }
                case ZSTANDARD: {
                    return FieldConfig.CompressionCodec.ZSTANDARD;
                }
                case LZ4: {
                    return FieldConfig.CompressionCodec.LZ4;
                }
            }
            throw new IllegalStateException("Unsupported chunk compression type: " + chunkCompressionType);
        }
        if (dictIdCompressionType != null) {
            switch (dictIdCompressionType) {
                case MV_ENTRY_DICT: {
                    return FieldConfig.CompressionCodec.MV_ENTRY_DICT;
                }
            }
            throw new IllegalStateException("Unsupported dictionary compression type: " + dictIdCompressionType);
        }
        return null;
    }

    @Nullable
    public FieldConfig.CompressionCodec getCompressionCodec() {
        return this._compressionCodec;
    }

    public boolean isDeriveNumDocsPerChunk() {
        return this._deriveNumDocsPerChunk;
    }

    public int getRawIndexWriterVersion() {
        return this._rawIndexWriterVersion;
    }

    public String getTargetMaxChunkSize() {
        return this._targetMaxChunkSize;
    }

    public int getTargetDocsPerChunk() {
        return this._targetDocsPerChunk;
    }

    @JsonIgnore
    public int getTargetMaxChunkSizeBytes() {
        return this._targetMaxChunkSizeBytes;
    }

    @JsonIgnore
    @Nullable
    public ChunkCompressionType getChunkCompressionType() {
        return this._chunkCompressionType;
    }

    @JsonIgnore
    @Nullable
    public DictIdCompressionType getDictIdCompressionType() {
        return this._dictIdCompressionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ForwardIndexConfig)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForwardIndexConfig that = (ForwardIndexConfig)((Object)o);
        return this._compressionCodec == that._compressionCodec && this._deriveNumDocsPerChunk == that._deriveNumDocsPerChunk && this._rawIndexWriterVersion == that._rawIndexWriterVersion && Objects.equals(this._targetMaxChunkSize, that._targetMaxChunkSize) && this._targetDocsPerChunk == that._targetDocsPerChunk;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this._compressionCodec, this._deriveNumDocsPerChunk, this._rawIndexWriterVersion, this._targetMaxChunkSize, this._targetDocsPerChunk);
    }

    public static class Builder {
        @Nullable
        private FieldConfig.CompressionCodec _compressionCodec;
        private boolean _deriveNumDocsPerChunk = false;
        private int _rawIndexWriterVersion = 2;
        private String _targetMaxChunkSize;
        private int _targetDocsPerChunk = 1000;

        public Builder() {
        }

        public Builder(ForwardIndexConfig other) {
            this._compressionCodec = other._compressionCodec;
            this._deriveNumDocsPerChunk = other._deriveNumDocsPerChunk;
            this._rawIndexWriterVersion = other._rawIndexWriterVersion;
            this._targetMaxChunkSize = other._targetMaxChunkSize;
            this._targetDocsPerChunk = other._targetDocsPerChunk;
        }

        public Builder withCompressionCodec(FieldConfig.CompressionCodec compressionCodec) {
            this._compressionCodec = compressionCodec;
            return this;
        }

        public Builder withDeriveNumDocsPerChunk(boolean deriveNumDocsPerChunk) {
            this._deriveNumDocsPerChunk = deriveNumDocsPerChunk;
            return this;
        }

        public Builder withRawIndexWriterVersion(int rawIndexWriterVersion) {
            this._rawIndexWriterVersion = rawIndexWriterVersion;
            return this;
        }

        public Builder withTargetMaxChunkSize(int targetMaxChunkSize) {
            this._targetMaxChunkSize = DataSizeUtils.fromBytes((long)targetMaxChunkSize);
            return this;
        }

        public Builder withTargetDocsPerChunk(int targetDocsPerChunk) {
            this._targetDocsPerChunk = targetDocsPerChunk;
            return this;
        }

        @Deprecated
        public Builder withCompressionType(ChunkCompressionType chunkCompressionType) {
            if (chunkCompressionType == null) {
                return this;
            }
            switch (chunkCompressionType) {
                case LZ4: 
                case LZ4_LENGTH_PREFIXED: {
                    this._compressionCodec = FieldConfig.CompressionCodec.LZ4;
                    break;
                }
                case PASS_THROUGH: {
                    this._compressionCodec = FieldConfig.CompressionCodec.PASS_THROUGH;
                    break;
                }
                case SNAPPY: {
                    this._compressionCodec = FieldConfig.CompressionCodec.SNAPPY;
                    break;
                }
                case ZSTANDARD: {
                    this._compressionCodec = FieldConfig.CompressionCodec.ZSTANDARD;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported chunk compression type: " + chunkCompressionType);
                }
            }
            return this;
        }

        @Deprecated
        public Builder withDictIdCompressionType(DictIdCompressionType dictIdCompressionType) {
            if (dictIdCompressionType == null) {
                return this;
            }
            Preconditions.checkArgument((dictIdCompressionType == DictIdCompressionType.MV_ENTRY_DICT ? 1 : 0) != 0, (Object)("Unsupported dictionary compression type: " + dictIdCompressionType));
            this._compressionCodec = FieldConfig.CompressionCodec.MV_ENTRY_DICT;
            return this;
        }

        public Builder withLegacyProperties(Map<String, Map<String, String>> propertiesByCol, String colName) {
            Map<String, String> colProps;
            if (propertiesByCol != null && (colProps = propertiesByCol.get(colName)) != null) {
                this.withLegacyProperties(colProps);
            }
            return this;
        }

        public Builder withLegacyProperties(Map<String, String> properties) {
            String newRawIndexVersion;
            String newDerive = properties.get("deriveNumDocsPerChunkForRawIndex");
            if (newDerive != null) {
                this.withDeriveNumDocsPerChunk(Boolean.parseBoolean(newDerive));
            }
            if ((newRawIndexVersion = properties.get("rawIndexWriterVersion")) != null) {
                this.withRawIndexWriterVersion(Integer.parseInt(newRawIndexVersion));
            }
            return this;
        }

        public ForwardIndexConfig build() {
            return new ForwardIndexConfig(false, this._compressionCodec, this._deriveNumDocsPerChunk, this._rawIndexWriterVersion, this._targetMaxChunkSize, this._targetDocsPerChunk);
        }
    }
}

