/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.creator;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.IndexCreator;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;

public interface BloomFilterCreator
extends IndexCreator {
    public FieldSpec.DataType getDataType();

    @Override
    default public void add(@Nonnull Object value, int dictId) {
        if (this.getDataType() == FieldSpec.DataType.BYTES) {
            this.add(BytesUtils.toHexString((byte[])((byte[])value)));
        } else {
            this.add(value.toString());
        }
    }

    @Override
    default public void add(@Nonnull Object[] values, @Nullable int[] dictIds) {
        if (this.getDataType() == FieldSpec.DataType.BYTES) {
            for (Object value : values) {
                this.add(BytesUtils.toHexString((byte[])((byte[])value)));
            }
        } else {
            for (Object value : values) {
                this.add(value.toString());
            }
        }
    }

    public void add(String var1);

    @Override
    public void seal() throws IOException;
}

