/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.creator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.apache.pinot.spi.config.table.IndexConfig;

public class H3IndexConfig
extends IndexConfig {
    public static final H3IndexConfig DISABLED = new H3IndexConfig(true, null);
    public static final String RESOLUTIONS_KEY = "resolutions";
    private final H3IndexResolution _resolution;

    public H3IndexConfig(H3IndexResolution resolution) {
        this(false, resolution);
    }

    @JsonCreator
    public H3IndexConfig(@JsonProperty(value="disabled") @Nullable Boolean disabled, @JsonProperty(value="resolution") H3IndexResolution resolution) {
        super(disabled);
        this._resolution = resolution;
    }

    public H3IndexConfig(@Nullable Map<String, String> properties) {
        super(Boolean.valueOf(false));
        Preconditions.checkArgument((properties != null && properties.containsKey(RESOLUTIONS_KEY) ? 1 : 0) != 0, (Object)"Properties must contain H3 resolutions");
        ArrayList<Integer> resolutions = new ArrayList<Integer>();
        try {
            for (String resolution : StringUtils.split((String)properties.get(RESOLUTIONS_KEY), (char)',')) {
                resolutions.add(Integer.parseInt(resolution));
            }
            this._resolution = new H3IndexResolution(resolutions);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("H3 index resolutions must be a list of integers, separated by comma", e);
        }
    }

    public H3IndexResolution getResolution() {
        return this._resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        H3IndexConfig that = (H3IndexConfig)((Object)o);
        return Objects.equals(this._resolution, that._resolution);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this._resolution);
    }
}

