/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.creator;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.IndexConfig;

public class VectorIndexConfig
extends IndexConfig {
    public static final VectorIndexConfig DISABLED = new VectorIndexConfig(true);
    private static final String VECTOR_INDEX_TYPE = "vectorIndexType";
    private static final String VECTOR_DIMENSION = "vectorDimension";
    private static final String VECTOR_DISTANCE_FUNCTION = "vectorDistanceFunction";
    private static final String VERSION = "version";
    private static final String DEFAULT_VERSION = "1";
    private static final VectorDistanceFunction DEFAULT_VECTOR_DISTANCE_FUNCTION = VectorDistanceFunction.COSINE;
    private String _vectorIndexType;
    private int _vectorDimension;
    private int _version;
    private VectorDistanceFunction _vectorDistanceFunction;
    private Map<String, String> _properties;

    public VectorIndexConfig(Boolean disabled) {
        super(disabled);
    }

    public VectorIndexConfig(@Nullable Map<String, String> properties) {
        super(Boolean.valueOf(false));
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"Properties must not be null");
        Preconditions.checkArgument((boolean)properties.containsKey(VECTOR_INDEX_TYPE), (Object)"Properties must contain vector index type");
        this._vectorIndexType = properties.get(VECTOR_INDEX_TYPE);
        Preconditions.checkArgument((boolean)properties.containsKey(VECTOR_DIMENSION), (Object)"Properties must contain vector dimension");
        this._vectorDimension = Integer.parseInt(properties.get(VECTOR_DIMENSION));
        this._vectorDistanceFunction = properties.containsKey(VECTOR_DISTANCE_FUNCTION) ? VectorDistanceFunction.valueOf(properties.get(VECTOR_DISTANCE_FUNCTION)) : DEFAULT_VECTOR_DISTANCE_FUNCTION;
        this._version = Integer.parseInt(properties.getOrDefault(VERSION, DEFAULT_VERSION));
        this._properties = properties;
    }

    public String getVectorIndexType() {
        return this._vectorIndexType;
    }

    public VectorIndexConfig setVectorIndexType(String vectorIndexType) {
        this._vectorIndexType = vectorIndexType;
        return this;
    }

    public int getVectorDimension() {
        return this._vectorDimension;
    }

    public VectorIndexConfig setVectorDimension(int vectorDimension) {
        this._vectorDimension = vectorDimension;
        return this;
    }

    public VectorDistanceFunction getVectorDistanceFunction() {
        return this._vectorDistanceFunction;
    }

    public VectorIndexConfig setVectorDistanceFunction(VectorDistanceFunction vectorDistanceFunction) {
        this._vectorDistanceFunction = vectorDistanceFunction;
        return this;
    }

    public int getVersion() {
        return this._version;
    }

    public VectorIndexConfig setVersion(int version) {
        this._version = version;
        return this;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public VectorIndexConfig setProperties(Map<String, String> properties) {
        this._properties = properties;
        return this;
    }

    public String toString() {
        return "VectorIndexConfig{_vectorIndexType='" + this._vectorIndexType + "', _vectorDimension=" + this._vectorDimension + ", _version=" + this._version + ", _vectorDistanceFunction=" + this._vectorDistanceFunction + ", _properties=" + this._properties + "}";
    }

    public static enum VectorDistanceFunction {
        COSINE,
        INNER_PRODUCT,
        EUCLIDEAN,
        DOT_PRODUCT;

    }
}

