/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.startree;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.StarTreeAggregationConfig;

public class AggregationSpec {
    public static final FieldConfig.CompressionCodec DEFAULT_COMPRESSION_CODEC = FieldConfig.CompressionCodec.PASS_THROUGH;
    public static final AggregationSpec DEFAULT = new AggregationSpec(null, null, null, null, null);
    private final FieldConfig.CompressionCodec _compressionCodec;
    private final boolean _deriveNumDocsPerChunk;
    private final int _indexVersion;
    private final int _targetMaxChunkSizeBytes;
    private final int _targetDocsPerChunk;

    public AggregationSpec(StarTreeAggregationConfig aggregationConfig) {
        this(aggregationConfig.getCompressionCodec(), aggregationConfig.getDeriveNumDocsPerChunk(), aggregationConfig.getIndexVersion(), aggregationConfig.getTargetMaxChunkSizeBytes(), aggregationConfig.getTargetDocsPerChunk());
    }

    public AggregationSpec(@Nullable FieldConfig.CompressionCodec compressionCodec, @Nullable Boolean deriveNumDocsPerChunk, @Nullable Integer indexVersion, @Nullable Integer targetMaxChunkSizeBytes, @Nullable Integer targetDocsPerChunk) {
        this._indexVersion = indexVersion != null ? indexVersion : 2;
        this._compressionCodec = compressionCodec != null ? compressionCodec : DEFAULT_COMPRESSION_CODEC;
        this._deriveNumDocsPerChunk = deriveNumDocsPerChunk != null ? deriveNumDocsPerChunk : false;
        this._targetMaxChunkSizeBytes = targetMaxChunkSizeBytes != null ? targetMaxChunkSizeBytes : 0x100000;
        this._targetDocsPerChunk = targetDocsPerChunk != null ? targetDocsPerChunk : 1000;
    }

    public FieldConfig.CompressionCodec getCompressionCodec() {
        return this._compressionCodec;
    }

    public boolean isDeriveNumDocsPerChunk() {
        return this._deriveNumDocsPerChunk;
    }

    public int getIndexVersion() {
        return this._indexVersion;
    }

    public int getTargetMaxChunkSizeBytes() {
        return this._targetMaxChunkSizeBytes;
    }

    public int getTargetDocsPerChunk() {
        return this._targetDocsPerChunk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregationSpec)) {
            return false;
        }
        AggregationSpec that = (AggregationSpec)o;
        return this._deriveNumDocsPerChunk == that._deriveNumDocsPerChunk && this._indexVersion == that._indexVersion && this._targetMaxChunkSizeBytes == that._targetMaxChunkSizeBytes && this._targetDocsPerChunk == that._targetDocsPerChunk && this._compressionCodec == that._compressionCodec;
    }

    public int hashCode() {
        return Objects.hash(this._compressionCodec, this._deriveNumDocsPerChunk, this._indexVersion, this._targetMaxChunkSizeBytes, this._targetDocsPerChunk);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("compressionCodec", (Object)this._compressionCodec).append("deriveNumDocsPerChunk", this._deriveNumDocsPerChunk).append("indexVersion", this._indexVersion).append("targetMaxChunkSizeBytes", this._targetMaxChunkSizeBytes).append("targetDocsPerChunk", this._targetDocsPerChunk).toString();
    }
}

