/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.List;

public class ByteBufferUtil {
    private static final ByteBufferCreator CREATOR;
    private static final List<CreatorSupplier> _SUPPLIERS;

    private ByteBufferUtil() {
    }

    public static ByteBuffer newDirectByteBuffer(long addr, int size, Object att) {
        return CREATOR.newDirectByteBuffer(addr, size, att);
    }

    static {
        _SUPPLIERS = Lists.newArrayList((Object[])new CreatorSupplier[]{() -> {
            Class<?> memorySegmentProxyClass = Class.forName("java.lang.foreign.MemorySegment");
            Constructor<?> dbbCC = Class.forName("java.nio.DirectByteBuffer").getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class, memorySegmentProxyClass);
            return (addr, size, att) -> {
                dbbCC.setAccessible(true);
                try {
                    return (ByteBuffer)dbbCC.newInstance(addr, size, att, null);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create DirectByteBuffer", e);
                }
            };
        }, () -> {
            Constructor<?> dbbCC = Class.forName("java.nio.DirectByteBuffer").getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            return (addr, size, att) -> {
                dbbCC.setAccessible(true);
                try {
                    return (ByteBuffer)dbbCC.newInstance(addr, size, att);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create DirectByteBuffer", e);
                }
            };
        }, () -> {
            Constructor<?> dbbCC = Class.forName("java.nio.DirectByteBuffer").getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            return (addr, size, att) -> {
                dbbCC.setAccessible(true);
                try {
                    return (ByteBuffer)dbbCC.newInstance(addr, size);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create DirectByteBuffer", e);
                }
            };
        }});
        ByteBufferCreator creator = null;
        ReflectiveOperationException firstException = null;
        for (CreatorSupplier supplier : _SUPPLIERS) {
            try {
                creator = supplier.createCreator();
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (creator == null) {
            throw new IllegalStateException("Cannot find a way to instantiate DirectByteBuffer. Please verify you are using a supported JVM", firstException);
        }
        CREATOR = creator;
    }

    private static interface ByteBufferCreator {
        public ByteBuffer newDirectByteBuffer(long var1, int var3, Object var4);
    }

    private static interface CreatorSupplier {
        public ByteBufferCreator createCreator() throws ClassNotFoundException, NoSuchMethodException;
    }
}

