/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PagedPinotOutputStream;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class CompoundDataBuffer
implements DataBuffer {
    private final DataBuffer[] _buffers;
    private final long[] _bufferOffsets;
    private int _lastBufferIndex = 0;
    private final ByteOrder _order;
    private final long _size;
    private final boolean _owner;

    public CompoundDataBuffer(DataBuffer[] buffers, ByteOrder order, boolean owner) {
        int i;
        this._owner = owner;
        this._buffers = buffers;
        this._bufferOffsets = new long[buffers.length];
        this._order = order;
        long offset = 0L;
        for (i = 0; i < buffers.length; ++i) {
            if (buffers[i].size() == 0L) {
                throw new IllegalArgumentException("Buffer at index " + i + " is empty");
            }
            if (buffers[i].order() == this._order) continue;
            buffers[i] = buffers[i].view(0L, buffers[i].size(), this._order);
        }
        for (i = 0; i < buffers.length; ++i) {
            this._bufferOffsets[i] = offset;
            long size = buffers[i].size();
            offset += size;
        }
        this._size = offset;
    }

    public CompoundDataBuffer(ByteBuffer[] buffers, ByteOrder order, boolean owner) {
        this(CompoundDataBuffer.asDataBufferArray(buffers), order, owner);
    }

    public CompoundDataBuffer(List<DataBuffer> buffers, ByteOrder order, boolean owner) {
        this(buffers.toArray(new DataBuffer[0]), order, owner);
    }

    private static DataBuffer[] asDataBufferArray(ByteBuffer[] buffers) {
        DataBuffer[] result = new DataBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            result[i] = PinotByteBuffer.wrap(buffers[i]);
        }
        return result;
    }

    private int getBufferIndex(long offset) {
        int result;
        int lastBufferIndex = this._lastBufferIndex;
        if (this._bufferOffsets[lastBufferIndex] > offset) {
            lastBufferIndex = 0;
        }
        for (int i = lastBufferIndex; i < this._bufferOffsets.length; ++i) {
            int result2;
            if (offset >= this._bufferOffsets[i]) continue;
            this._lastBufferIndex = result2 = i - 1;
            return result2;
        }
        this._lastBufferIndex = result = this._bufferOffsets.length - 1;
        return result;
    }

    private ByteBuffer copy(long offset, int length) {
        if (offset + (long)length > this._size) {
            throw new BufferUnderflowException();
        }
        byte[] result = new byte[length];
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        DataBuffer buffer = this._buffers[bufferIndex];
        int toCopy = (int)Math.min((long)length, buffer.size() - inBufferIndex);
        buffer.copyTo(inBufferIndex, result, 0, toCopy);
        for (int remaining = length - toCopy; remaining > 0; remaining -= toCopy) {
            buffer = this._buffers[++bufferIndex];
            toCopy = (int)Math.min((long)remaining, buffer.size());
            buffer.copyTo(0L, result, length - remaining, toCopy);
        }
        return ByteBuffer.wrap(result).order(this._order);
    }

    @Override
    public void readFrom(long offset, byte[] input, int srcOffset, int size) {
        if (offset + (long)size > this._size) {
            throw new BufferOverflowException();
        }
        int bufferIndex = this.getBufferIndex(offset);
        int remaining = size;
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        while (remaining > 0) {
            DataBuffer buffer = this._buffers[bufferIndex];
            int toRead = (int)Math.min((long)remaining, buffer.size() - inBufferIndex);
            buffer.readFrom(inBufferIndex, input, srcOffset, toRead);
            ++bufferIndex;
            remaining -= toRead;
            srcOffset += toRead;
            inBufferIndex = 0L;
        }
    }

    @Override
    public void readFrom(long offset, ByteBuffer input) {
        if (offset + (long)input.remaining() > this._size) {
            throw new BufferOverflowException();
        }
        int startLimit = input.limit();
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        while (input.hasRemaining()) {
            DataBuffer buffer = this._buffers[bufferIndex];
            int toRead = (int)Math.min((long)input.remaining(), buffer.size() - inBufferIndex);
            input.limit(input.position() + toRead);
            buffer.readFrom(inBufferIndex, input);
            input.position(input.limit());
            input.limit(startLimit);
            ++bufferIndex;
            inBufferIndex = 0L;
        }
    }

    @Override
    public void readFrom(long offset, File file, long srcOffset, long size) throws IOException {
        if (offset + size > this._size) {
            throw new BufferOverflowException();
        }
        int bufferIndex = this.getBufferIndex(offset);
        DataBuffer buffer = this._buffers[bufferIndex];
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        long toRead = Math.min(size, buffer.size() - inBufferIndex);
        buffer.readFrom(inBufferIndex, file, srcOffset, toRead);
        long fileOffset = srcOffset + toRead;
        long remaining = size - toRead;
        while (remaining > 0L) {
            buffer = this._buffers[++bufferIndex];
            toRead = Math.min(remaining, buffer.size());
            buffer.readFrom(0L, file, fileOffset, toRead);
            remaining -= toRead;
            fileOffset += toRead;
        }
    }

    @Override
    public void copyTo(long offset, byte[] buffer, int destOffset, int size) {
        if (offset + (long)size > this._size) {
            throw new BufferUnderflowException();
        }
        int bufferIndex = this.getBufferIndex(offset);
        int remaining = size;
        DataBuffer bufferToCopy = this._buffers[bufferIndex];
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        int toCopy = (int)Math.min((long)remaining, bufferToCopy.size() - inBufferIndex);
        bufferToCopy.copyTo(inBufferIndex, buffer, destOffset, toCopy);
        remaining -= toCopy;
        destOffset += toCopy;
        while (remaining > 0) {
            bufferToCopy = this._buffers[++bufferIndex];
            toCopy = (int)Math.min((long)remaining, bufferToCopy.size());
            bufferToCopy.copyTo(0L, buffer, destOffset, toCopy);
            remaining -= toCopy;
            destOffset += toCopy;
        }
    }

    @Override
    public void copyTo(long offset, DataBuffer buffer, long destOffset, long size) {
        if (offset + size > this._size) {
            throw new BufferUnderflowException();
        }
        int bufferIndex = this.getBufferIndex(offset);
        long remaining = size;
        DataBuffer bufferToCopy = this._buffers[bufferIndex];
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        long toCopy = Math.min(remaining, bufferToCopy.size() - inBufferIndex);
        bufferToCopy.copyTo(inBufferIndex, buffer, destOffset, toCopy);
        ++bufferIndex;
        remaining -= toCopy;
        destOffset += toCopy;
        while (remaining > 0L) {
            bufferToCopy = this._buffers[bufferIndex];
            toCopy = Math.min(remaining, bufferToCopy.size());
            bufferToCopy.copyTo(0L, buffer, destOffset, toCopy);
            ++bufferIndex;
            remaining -= toCopy;
            destOffset += toCopy;
        }
    }

    @Override
    public byte getByte(long offset) {
        int bufferIndex = this.getBufferIndex(offset);
        DataBuffer buffer = this._buffers[bufferIndex];
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        return buffer.getByte(inBufferIndex);
    }

    @Override
    public void putByte(long offset, byte value) {
        int bufferIndex = this.getBufferIndex(offset);
        DataBuffer buffer = this._buffers[bufferIndex];
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        buffer.putByte(inBufferIndex, value);
    }

    @Override
    public char getChar(long offset) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 2L <= (buffer = this._buffers[bufferIndex]).size()) {
            return buffer.getChar(inBufferIndex);
        }
        ByteBuffer byteBuffer = this.copy(offset, 2);
        return byteBuffer.getChar();
    }

    @Override
    public void putChar(long offset, char value) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 2L <= (buffer = this._buffers[bufferIndex]).size()) {
            buffer.putChar(inBufferIndex, value);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(this._order).putChar(value);
            byteBuffer.flip();
            this.readFrom(offset, byteBuffer);
        }
    }

    @Override
    public short getShort(long offset) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 2L <= (buffer = this._buffers[bufferIndex]).size()) {
            return buffer.getShort(inBufferIndex);
        }
        ByteBuffer byteBuffer = this.copy(offset, 2);
        return byteBuffer.getShort();
    }

    @Override
    public void putShort(long offset, short value) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 2L <= (buffer = this._buffers[bufferIndex]).size()) {
            buffer.putShort(inBufferIndex, value);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(this._order).putShort(value);
            byteBuffer.flip();
            this.readFrom(offset, byteBuffer);
        }
    }

    @Override
    public int getInt(long offset) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 4L <= (buffer = this._buffers[bufferIndex]).size()) {
            return buffer.getInt(inBufferIndex);
        }
        ByteBuffer byteBuffer = this.copy(offset, 4);
        return byteBuffer.getInt();
    }

    @Override
    public void putInt(long offset, int value) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 4L <= (buffer = this._buffers[bufferIndex]).size()) {
            buffer.putInt(inBufferIndex, value);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this._order).putInt(value);
            byteBuffer.flip();
            this.readFrom(offset, byteBuffer);
        }
    }

    @Override
    public long getLong(long offset) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 8L <= (buffer = this._buffers[bufferIndex]).size()) {
            return buffer.getLong(inBufferIndex);
        }
        ByteBuffer byteBuffer = this.copy(offset, 8);
        return byteBuffer.getLong();
    }

    @Override
    public void putLong(long offset, long value) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 8L <= (buffer = this._buffers[bufferIndex]).size()) {
            buffer.putLong(inBufferIndex, value);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this._order).putLong(value);
            byteBuffer.flip();
            this.readFrom(offset, byteBuffer);
        }
    }

    @Override
    public float getFloat(long offset) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 4L <= (buffer = this._buffers[bufferIndex]).size()) {
            return buffer.getFloat(inBufferIndex);
        }
        ByteBuffer byteBuffer = this.copy(offset, 4);
        return byteBuffer.getFloat();
    }

    @Override
    public void putFloat(long offset, float value) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 4L <= (buffer = this._buffers[bufferIndex]).size()) {
            buffer.putFloat(inBufferIndex, value);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this._order).putFloat(value);
            byteBuffer.flip();
            this.readFrom(offset, byteBuffer);
        }
    }

    @Override
    public double getDouble(long offset) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 8L <= (buffer = this._buffers[bufferIndex]).size()) {
            return buffer.getDouble(inBufferIndex);
        }
        ByteBuffer byteBuffer = this.copy(offset, 8);
        return byteBuffer.getDouble();
    }

    @Override
    public void putDouble(long offset, double value) {
        DataBuffer buffer;
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + 8L <= (buffer = this._buffers[bufferIndex]).size()) {
            buffer.putDouble(inBufferIndex, value);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this._order).putDouble(value);
            byteBuffer.flip();
            this.readFrom(offset, byteBuffer);
        }
    }

    @Override
    public long size() {
        return this._size;
    }

    @Override
    public ByteOrder order() {
        return this._order;
    }

    @Override
    public DataBuffer view(long start, long end, ByteOrder byteOrder) {
        int endBufferIndex;
        if (start < 0L || end > this._size || start > end) {
            throw new IllegalArgumentException("Invalid start/end: " + start + "/" + end);
        }
        if (start == 0L && end == this._size && byteOrder == this._order) {
            return new CompoundDataBuffer(this._buffers, this._order, false);
        }
        int startBufferIndex = this.getBufferIndex(start);
        if (startBufferIndex == (endBufferIndex = this.getBufferIndex(end - 1L))) {
            long bufferOffset = this._bufferOffsets[startBufferIndex];
            DataBuffer buffer = this._buffers[startBufferIndex];
            return buffer.view(start - bufferOffset, end - bufferOffset, byteOrder);
        }
        DataBuffer firstBuffer = this._buffers[startBufferIndex].view(start - this._bufferOffsets[startBufferIndex], this._buffers[startBufferIndex].size(), byteOrder);
        DataBuffer lastBuffer = this._buffers[endBufferIndex].view(0L, end - this._bufferOffsets[endBufferIndex], byteOrder);
        DataBuffer[] buffers = new DataBuffer[endBufferIndex - startBufferIndex + 1];
        buffers[0] = firstBuffer;
        if (buffers.length > 2) {
            System.arraycopy(this._buffers, startBufferIndex + 1, buffers, 1, buffers.length - 2);
        }
        buffers[buffers.length - 1] = lastBuffer;
        return new CompoundDataBuffer(buffers, byteOrder, false);
    }

    @Override
    public ImmutableRoaringBitmap viewAsRoaringBitmap(long offset, int length) {
        int bufferIndex = this.getBufferIndex(offset);
        DataBuffer buffer = this._buffers[bufferIndex];
        if ((long)length < buffer.size()) {
            return buffer.viewAsRoaringBitmap(offset, length);
        }
        ByteBuffer copy = this.copy(offset, length);
        return new ImmutableRoaringBitmap(copy);
    }

    @Override
    public ByteBuffer copyOrView(long offset, int size, ByteOrder byteOrder) {
        DataBuffer buffer;
        if (offset + (long)size > this._size) {
            throw new BufferUnderflowException();
        }
        int bufferIndex = this.getBufferIndex(offset);
        long inBufferIndex = offset - this._bufferOffsets[bufferIndex];
        if (inBufferIndex + (long)size <= (buffer = this._buffers[bufferIndex]).size()) {
            return buffer.copyOrView(inBufferIndex, size, byteOrder);
        }
        return this.copy(offset, size).order(byteOrder);
    }

    @Override
    public void flush() {
        RuntimeException firstException = null;
        for (DataBuffer buffer : this._buffers) {
            try {
                buffer.flush();
            }
            catch (RuntimeException ex) {
                if (firstException != null) continue;
                firstException = ex;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._owner) {
            return;
        }
        IOException firstException = null;
        for (DataBuffer buffer : this._buffers) {
            try {
                buffer.close();
            }
            catch (IOException ex) {
                if (firstException != null) continue;
                firstException = ex;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public DataBuffer[] getBuffers() {
        return this._buffers;
    }

    @Override
    public void appendAsByteBuffers(List<ByteBuffer> appendTo) {
        for (DataBuffer buffer : this._buffers) {
            buffer.appendAsByteBuffers(appendTo);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataBuffer)) {
            return false;
        }
        DataBuffer buffer = (DataBuffer)o;
        return DataBuffer.sameContent(this, buffer);
    }

    public int hashCode() {
        return DataBuffer.commonHashCode(this);
    }

    public static class Builder {
        private final ByteOrder _order;
        private final boolean _owner;
        private final ArrayList<DataBuffer> _buffers = new ArrayList();

        public Builder() {
            this(ByteOrder.BIG_ENDIAN, false);
        }

        public Builder(ByteOrder order) {
            this(order, false);
        }

        public Builder(boolean owner) {
            this(ByteOrder.BIG_ENDIAN, owner);
        }

        public Builder(ByteOrder order, boolean owner) {
            this._order = order;
            this._owner = owner;
        }

        public Builder addBuffer(DataBuffer buffer) {
            if (buffer instanceof CompoundDataBuffer) {
                CompoundDataBuffer compoundBuffer = (CompoundDataBuffer)buffer;
                for (DataBuffer childBuffer : compoundBuffer.getBuffers()) {
                    this.addBuffer(childBuffer);
                }
                return this;
            }
            if (buffer.size() != 0L) {
                this._buffers.add(buffer);
            }
            return this;
        }

        public Builder addPagedOutputStream(PagedPinotOutputStream stream) {
            ByteBuffer[] pages;
            for (ByteBuffer page : pages = stream.getPages()) {
                this.addBuffer(PinotByteBuffer.wrap(page));
            }
            return this;
        }

        public CompoundDataBuffer build() {
            return new CompoundDataBuffer(this._buffers, this._order, this._owner);
        }
    }
}

