/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Objects;
import org.apache.pinot.segment.spi.memory.DataBufferPinotInputStream;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.apache.pinot.segment.spi.memory.PinotInputStream;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public interface DataBuffer
extends Closeable {
    default public byte getByte(int offset) {
        return this.getByte((long)offset);
    }

    public byte getByte(long var1);

    default public void putByte(int offset, byte value) {
        this.putByte((long)offset, value);
    }

    public void putByte(long var1, byte var3);

    default public char getChar(int offset) {
        return this.getChar((long)offset);
    }

    public char getChar(long var1);

    default public void putChar(int offset, char value) {
        this.putChar((long)offset, value);
    }

    public void putChar(long var1, char var3);

    default public short getShort(int offset) {
        return this.getShort((long)offset);
    }

    public short getShort(long var1);

    default public void putShort(int offset, short value) {
        this.putShort((long)offset, value);
    }

    public void putShort(long var1, short var3);

    default public int getInt(int offset) {
        return this.getInt((long)offset);
    }

    public int getInt(long var1);

    default public void putInt(int offset, int value) {
        this.putInt((long)offset, value);
    }

    public void putInt(long var1, int var3);

    default public long getLong(int offset) {
        return this.getLong((long)offset);
    }

    public long getLong(long var1);

    default public void putLong(int offset, long value) {
        this.putLong((long)offset, value);
    }

    public void putLong(long var1, long var3);

    default public float getFloat(int offset) {
        return this.getFloat((long)offset);
    }

    public float getFloat(long var1);

    default public void putFloat(int offset, float value) {
        this.putFloat((long)offset, value);
    }

    public void putFloat(long var1, float var3);

    default public double getDouble(int offset) {
        return this.getDouble((long)offset);
    }

    public double getDouble(long var1);

    default public void putDouble(int offset, double value) {
        this.putDouble((long)offset, value);
    }

    public void putDouble(long var1, double var3);

    public void copyTo(long var1, byte[] var3, int var4, int var5);

    default public void copyTo(long offset, byte[] buffer) {
        this.copyTo(offset, buffer, 0, buffer.length);
    }

    public void copyTo(long var1, DataBuffer var3, long var4, long var6);

    default public void copyTo(long offset, ByteBuffer buffer, int destOffset, int size) {
        PinotByteBuffer wrap = PinotByteBuffer.wrap(buffer);
        this.copyTo(offset, wrap, (long)destOffset, (long)size);
    }

    public void readFrom(long var1, byte[] var3, int var4, int var5);

    default public void readFrom(long offset, byte[] buffer) {
        this.readFrom(offset, buffer, 0, buffer.length);
    }

    public void readFrom(long var1, ByteBuffer var3);

    public void readFrom(long var1, File var3, long var4, long var6) throws IOException;

    public long size();

    public ByteOrder order();

    public DataBuffer view(long var1, long var3, ByteOrder var5);

    default public DataBuffer view(long start, long end) {
        return this.view(start, end, this.order());
    }

    public void flush();

    default public PinotInputStream openInputStream() {
        return new DataBufferPinotInputStream(this);
    }

    default public PinotInputStream openInputStream(long offset) {
        return this.openInputStream(offset, this.size() - offset);
    }

    default public PinotInputStream openInputStream(long offset, long length) {
        return new DataBufferPinotInputStream(this, offset, offset + length);
    }

    public ImmutableRoaringBitmap viewAsRoaringBitmap(long var1, int var3);

    public ByteBuffer copyOrView(long var1, int var3, ByteOrder var4);

    public void appendAsByteBuffers(List<ByteBuffer> var1);

    default public ByteBuffer copyOrView(long offset, int size) {
        return this.copyOrView(offset, size, this.order());
    }

    public static boolean sameContent(DataBuffer buffer1, DataBuffer buffer2) {
        long i;
        long size = buffer1.size();
        if (size != buffer2.size()) {
            return false;
        }
        DataBuffer nativeBuffer1 = buffer1.view(0L, size, ByteOrder.nativeOrder());
        DataBuffer nativeBuffer2 = buffer2.view(0L, size, ByteOrder.nativeOrder());
        long maxLong = size & 0xFFFFFFFFFFFFFFF8L;
        for (i = 0L; i < maxLong; i += 8L) {
            if (nativeBuffer1.getLong(i) == nativeBuffer2.getLong(i)) continue;
            return false;
        }
        for (i = maxLong; i < size; ++i) {
            if (buffer1.getByte(i) == buffer2.getByte(i)) continue;
            return false;
        }
        return true;
    }

    public static int commonHashCode(DataBuffer dataBuffer) {
        long lastLong;
        long firstLong;
        long size = dataBuffer.size();
        int intSize = size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
        switch (intSize) {
            case 0: {
                firstLong = 0L;
                lastLong = 0L;
                break;
            }
            case 1: {
                lastLong = firstLong = (long)dataBuffer.getByte(0);
                break;
            }
            case 2: {
                lastLong = firstLong = (long)dataBuffer.getShort(0);
                break;
            }
            case 3: {
                firstLong = dataBuffer.getShort(0);
                lastLong = dataBuffer.getShort(1);
                break;
            }
            case 4: {
                lastLong = firstLong = (long)dataBuffer.getInt(0);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                firstLong = dataBuffer.getInt(0);
                lastLong = dataBuffer.getInt(intSize - 4);
                break;
            }
            default: {
                firstLong = dataBuffer.getLong(0);
                lastLong = dataBuffer.getLong(size - 8L);
            }
        }
        return Objects.hash(size, firstLong, lastLong);
    }
}

