/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.apache.pinot.segment.spi.memory.PinotInputStream;

public class DataBufferPinotInputStream
extends PinotInputStream {
    private final DataBuffer _dataBuffer;
    private long _currentOffset;

    public DataBufferPinotInputStream(DataBuffer dataBuffer) {
        this(dataBuffer, 0L, dataBuffer.size());
    }

    public DataBufferPinotInputStream(DataBuffer dataBuffer, long startOffset, long endOffset) {
        this._dataBuffer = dataBuffer.view(startOffset, endOffset, ByteOrder.BIG_ENDIAN);
        this._currentOffset = 0L;
    }

    @Override
    public long getCurrentOffset() {
        return this._currentOffset;
    }

    @Override
    public void seek(long newPos) {
        if (newPos < 0L || newPos > this._dataBuffer.size()) {
            throw new IllegalArgumentException("Invalid new position: " + newPos);
        }
        this._currentOffset = newPos;
    }

    @Override
    public int read(ByteBuffer buf) {
        int remaining = this.available();
        if (remaining == 0) {
            return -1;
        }
        PinotByteBuffer wrap = PinotByteBuffer.wrap(buf);
        int toRead = Math.min(remaining, buf.remaining());
        if (toRead > 0) {
            this._dataBuffer.copyTo(this._currentOffset, wrap, 0L, (long)toRead);
            this._currentOffset += (long)toRead;
        }
        return toRead;
    }

    @Override
    public int read() {
        if (this._currentOffset >= this._dataBuffer.size()) {
            return -1;
        }
        return this._dataBuffer.getByte(this._currentOffset++) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("off=" + off + ", len=" + len + ", b.length=" + b.length);
        }
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        int result = Math.min(available, len);
        this._dataBuffer.copyTo(this._currentOffset, b, off, result);
        this._currentOffset += (long)result;
        return result;
    }

    @Override
    public long skip(long n) {
        long increase = Math.min(n, this.availableLong());
        this._currentOffset += increase;
        return increase;
    }

    @Override
    public long availableLong() {
        return this._dataBuffer.size() - this._currentOffset;
    }

    @Override
    public int available() {
        long available = this._dataBuffer.size() - this._currentOffset;
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws EOFException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative: " + len);
        }
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off=" + off + ", len=" + len + ", b.length=" + b.length);
        }
        boolean eof = this.availableLong() < (long)len;
        this._dataBuffer.copyTo(this._currentOffset, b, off, len);
        this._currentOffset += (long)len;
        if (eof) {
            throw new EOFException();
        }
    }

    @Override
    public boolean readBoolean() throws EOFException {
        if (this._currentOffset >= this._dataBuffer.size()) {
            throw new EOFException();
        }
        return this._dataBuffer.getByte(this._currentOffset++) != 0;
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.availableLong() < 1L) {
            throw new EOFException();
        }
        return this._dataBuffer.getByte(this._currentOffset++);
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        if (this.availableLong() < 1L) {
            throw new EOFException();
        }
        return this._dataBuffer.getByte(this._currentOffset++) & 0xFF;
    }

    @Override
    public short readShort() throws EOFException {
        if (this.availableLong() < 2L) {
            throw new EOFException();
        }
        short result = this._dataBuffer.getShort(this._currentOffset);
        this._currentOffset += 2L;
        return result;
    }

    @Override
    public int readUnsignedShort() throws EOFException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws EOFException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws EOFException {
        if (this.availableLong() < 4L) {
            throw new EOFException();
        }
        int result = this._dataBuffer.getInt(this._currentOffset);
        this._currentOffset += 4L;
        return result;
    }

    @Override
    public long readLong() throws EOFException {
        if (this.availableLong() < 8L) {
            throw new EOFException();
        }
        long result = this._dataBuffer.getLong(this._currentOffset);
        this._currentOffset += 8L;
        return result;
    }

    @Override
    public float readFloat() throws EOFException {
        if (this.availableLong() < 4L) {
            throw new EOFException();
        }
        float result = this._dataBuffer.getFloat(this._currentOffset);
        this._currentOffset += 4L;
        return result;
    }

    @Override
    public double readDouble() throws EOFException {
        if (this.availableLong() < 8L) {
            throw new EOFException();
        }
        double result = this._dataBuffer.getDouble(this._currentOffset);
        this._currentOffset += 8L;
        return result;
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return new DataInputStream(this).readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this).readUTF();
    }
}

