/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory.unsafe;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.memory.NonNativePinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotBufferFactory;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.unsafe.DirectMemory;
import org.apache.pinot.segment.spi.memory.unsafe.MmapMemory;
import org.apache.pinot.segment.spi.memory.unsafe.UnsafePinotBuffer;
import xerial.larray.impl.OSInfo;

public class UnsafePinotBufferFactory
implements PinotBufferFactory {
    public UnsafePinotBufferFactory() {
        if (OSInfo.isWindows()) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + " cannot be used in Windows");
        }
    }

    @Override
    public PinotDataBuffer allocateDirect(long size, ByteOrder byteOrder) {
        UnsafePinotBuffer buffer = new UnsafePinotBuffer(new DirectMemory(size), true);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return buffer;
        }
        return new NonNativePinotDataBuffer(buffer);
    }

    @Override
    public PinotDataBuffer mapFile(File file, boolean readOnly, long offset, long size, ByteOrder byteOrder) throws IOException {
        UnsafePinotBuffer buffer = new UnsafePinotBuffer(new MmapMemory(file, readOnly, offset, size), true);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return buffer;
        }
        return new NonNativePinotDataBuffer(buffer);
    }
}

