/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition;

import com.google.common.base.Preconditions;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class ModuloPartitionFunction
implements PartitionFunction {
    private static final String NAME = "Modulo";
    private final int _numPartitions;

    public ModuloPartitionFunction(int numPartitions) {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (String)"Number of partitions must be > 0, specified", (int)numPartitions);
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(String value) {
        return this.toNonNegative((int)(Long.parseLong(value) % (long)this._numPartitions));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }

    private int toNonNegative(int partition) {
        return partition < 0 ? partition + this._numPartitions : partition;
    }
}

