/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.chromeinspector.DebuggerSuspendedInfo;
import com.oracle.truffle.tools.chromeinspector.RemoteObjectsHandler;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.chromeinspector.SuspendThreadExecutable;
import com.oracle.truffle.tools.chromeinspector.server.CommandProcessException;
import com.oracle.truffle.tools.chromeinspector.types.CallArgument;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public final class InspectorExecutionContext {
    public static final String VALUE_NOT_READABLE = "<not readable>";
    private static final AtomicLong LAST_ID = new AtomicLong(0L);
    private final String name;
    private final TruffleInstrument.Env env;
    private final PrintWriter err;
    private final List<Listener> listeners = Collections.synchronizedList(new ArrayList(3));
    private final long id = LAST_ID.incrementAndGet();
    private final boolean[] runPermission = new boolean[]{false};
    private final boolean inspectInternal;
    private final boolean inspectInitialization;
    private final List<URI> sourceRoots;
    private final TruffleLogger log;
    private final boolean allowToStringSideEffects = true;
    private volatile DebuggerSuspendedInfo suspendedInfo;
    private volatile SuspendedThreadExecutor suspendThreadExecutor;
    private RemoteObjectsHandler roh;
    private volatile ScriptsHandler scriptsHandler;
    private volatile EventBinding<ScriptsHandler> schBinding;
    private int schCounter;
    private volatile String lastMimeType = "text/javascript";
    private volatile String lastLanguage = "js";
    private boolean synchronous = false;
    private boolean customObjectFormatterEnabled = false;

    public InspectorExecutionContext(String name, boolean inspectInternal, boolean inspectInitialization, TruffleInstrument.Env env, List<URI> sourceRoots, PrintWriter err) {
        this.name = name;
        this.inspectInternal = inspectInternal;
        this.inspectInitialization = inspectInitialization;
        this.env = env;
        this.sourceRoots = sourceRoots;
        this.err = err;
        this.log = env.getLogger("");
    }

    public boolean isInspectInternal() {
        return this.inspectInternal;
    }

    public boolean isInspectInitialization() {
        return this.inspectInitialization;
    }

    public boolean areToStringSideEffectsAllowed() {
        return true;
    }

    public TruffleInstrument.Env getEnv() {
        return this.env;
    }

    public long getId() {
        return this.id;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public void logMessage(String prefix, Object message) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("CONTEXT " + this.id + " " + prefix + String.valueOf(message));
        }
    }

    public void logException(Throwable ex) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "CONTEXT " + this.id, ex);
        }
    }

    public void logException(String prefix, Throwable ex) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "CONTEXT " + this.id + " " + prefix, ex);
        }
    }

    Iterable<URI> getSourcePath() {
        return this.sourceRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRunIfWaitingForDebugger() {
        this.fireContextCreated();
        boolean[] blArray = this.runPermission;
        synchronized (this.runPermission) {
            this.runPermission[0] = true;
            this.runPermission.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRun() {
        boolean[] blArray = this.runPermission;
        synchronized (this.runPermission) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.runPermission[0];
        }
    }

    public ScriptsHandler acquireScriptsHandler() {
        return this.acquireScriptsHandler(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScriptsHandler acquireScriptsHandler(DebuggerSession debuggerSession) {
        ScriptsHandler sh;
        boolean attachListener = false;
        InspectorExecutionContext inspectorExecutionContext = this;
        synchronized (inspectorExecutionContext) {
            sh = this.scriptsHandler;
            if (sh == null) {
                this.scriptsHandler = sh = new ScriptsHandler(this.env, this.inspectInternal);
                attachListener = true;
                this.schCounter = 0;
            }
            ++this.schCounter;
        }
        if (debuggerSession != null) {
            sh.setDebuggerSession(debuggerSession);
        }
        if (attachListener) {
            this.schBinding = this.env.getInstrumenter().attachLoadSourceListener(SourceFilter.ANY, (LoadSourceListener)sh, true);
        }
        return sh;
    }

    public synchronized void releaseScriptsHandler() {
        if (--this.schCounter == 0) {
            this.schBinding.dispose();
            this.schBinding = null;
            this.scriptsHandler.dispose();
            this.scriptsHandler = null;
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireContextCreated() {
        for (Listener l : this.listeners) {
            l.contextCreated(this.id, this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRunPermission() throws InterruptedException {
        if (this.synchronous) {
            return;
        }
        boolean[] blArray = this.runPermission;
        synchronized (this.runPermission) {
            while (!this.runPermission[0]) {
                this.runPermission.wait();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized RemoteObjectsHandler getRemoteObjectsHandler() {
        if (this.roh == null) {
            this.roh = new RemoteObjectsHandler(this);
        }
        return this.roh;
    }

    public RemoteObject createAndRegister(DebugValue value, boolean generatePreview) {
        RemoteObject ro = new RemoteObject(value, generatePreview, this);
        if (ro.getId() != null) {
            this.getRemoteObjectsHandler().register(ro);
        }
        return ro;
    }

    void setValue(DebugValue debugValue, CallArgument newValue) {
        debugValue.set(this.getDebugValue(newValue, debugValue.getSession()));
    }

    DebugValue getDebugValue(CallArgument newValue, DebuggerSession session) {
        String objectId = newValue.getObjectId();
        if (objectId != null) {
            RemoteObject obj = this.getRemoteObjectsHandler().getRemote(objectId);
            return obj.getDebugValue();
        }
        return session.createPrimitiveValue(newValue.getPrimitiveValue(), null);
    }

    void setSuspendThreadExecutor(SuspendedThreadExecutor suspendThreadExecutor) {
        this.suspendThreadExecutor = suspendThreadExecutor;
    }

    <T> T executeInSuspendThread(final SuspendThreadExecutable<T> executable) throws NoSuspendedThreadException, CommandProcessException {
        Object params;
        if (this.synchronous) {
            try {
                return executable.executeCommand();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (DebugException dex) {
                return executable.processException(dex);
            }
        }
        final CompletableFuture cf = new CompletableFuture();
        this.suspendThreadExecutor.execute(new CancellableRunnable(){
            final /* synthetic */ InspectorExecutionContext this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Object params = null;
                try {
                    params = executable.executeCommand();
                    cf.complete(params);
                }
                catch (ThreadDeath td) {
                    cf.completeExceptionally(td);
                    throw td;
                }
                catch (DebugException dex) {
                    cf.complete(executable.processException(dex));
                }
                catch (Throwable t) {
                    cf.completeExceptionally(t);
                }
            }

            @Override
            public void cancel() {
                cf.completeExceptionally(new NoSuspendedThreadException("Resuming..."));
            }
        });
        try {
            params = cf.get();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof CommandProcessException) {
                throw (CommandProcessException)cause;
            }
            if (cause instanceof NoSuspendedThreadException) {
                throw (NoSuspendedThreadException)cause;
            }
            if (this.err != null) {
                cause.printStackTrace(this.err);
            }
            throw new CommandProcessException(ex.getLocalizedMessage());
        }
        catch (InterruptedException ex) {
            throw new CommandProcessException(ex.getLocalizedMessage());
        }
        return params;
    }

    void setLastLanguage(String language, String mimeType) {
        this.lastLanguage = language;
        this.lastMimeType = mimeType;
    }

    String getLastLanguage() {
        return this.lastLanguage;
    }

    String getLastMimeType() {
        return this.lastMimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSuspendedInfo(DebuggerSuspendedInfo suspendedInfo) {
        this.suspendedInfo = suspendedInfo;
        if (suspendedInfo == null) {
            InspectorExecutionContext inspectorExecutionContext = this;
            synchronized (inspectorExecutionContext) {
                if (this.roh != null) {
                    this.roh.reset();
                }
            }
        }
    }

    DebuggerSuspendedInfo getSuspendedInfo() {
        return this.suspendedInfo;
    }

    public static void resetIDs() {
        LAST_ID.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.suspendedInfo = null;
        this.suspendThreadExecutor = null;
        this.roh = null;
        assert (this.scriptsHandler == null);
        boolean[] blArray = this.runPermission;
        synchronized (this.runPermission) {
            this.runPermission[0] = true;
            this.runPermission.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setSynchronous(boolean synchronousExecution) {
        this.synchronous = synchronousExecution;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    void setCustomObjectFormatterEnabled(boolean enabled) {
        this.customObjectFormatterEnabled = enabled;
    }

    public boolean isCustomObjectFormatterEnabled() {
        return this.customObjectFormatterEnabled;
    }

    public static interface Listener {
        public void contextCreated(long var1, String var3);

        public void contextDestroyed(long var1, String var3);
    }

    static interface SuspendedThreadExecutor {
        public void execute(CancellableRunnable var1) throws NoSuspendedThreadException;
    }

    static interface CancellableRunnable
    extends Runnable {
        public void cancel();
    }

    static final class NoSuspendedThreadException
    extends Exception {
        private static final long serialVersionUID = 2834058024185219386L;

        private NoSuspendedThreadException(String message) {
            super(message);
        }

        static void raise() throws NoSuspendedThreadException {
            throw new NoSuspendedThreadException("<Not suspended>");
        }

        static void raiseResuming() throws NoSuspendedThreadException {
            throw new NoSuspendedThreadException("<Resuming...>");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

