/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.server;

public final class ConnectionWatcher {
    private volatile Boolean opened = null;
    private volatile boolean doWaitForClose = false;

    public boolean shouldWaitForClose() {
        return !this.isClosed() && this.doWaitForClose;
    }

    private boolean shouldWaitForOpen() {
        return this.opened == null;
    }

    public synchronized void waitForClose() {
        while (!this.isClosed()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForOpen() {
        if (this.shouldWaitForOpen()) {
            ConnectionWatcher connectionWatcher = this;
            synchronized (connectionWatcher) {
                while (this.shouldWaitForOpen()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    public void setWaitForClose() {
        this.doWaitForClose = true;
    }

    public synchronized void notifyOpen() {
        this.opened = Boolean.TRUE;
        this.notifyAll();
    }

    public synchronized void notifyClosing() {
        this.opened = Boolean.FALSE;
        this.notifyAll();
    }

    private boolean isClosed() {
        return this.opened == Boolean.FALSE;
    }
}

