/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.server;

import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.instrument.InspectorWSConnection;
import com.oracle.truffle.tools.chromeinspector.instrument.KeyStoreOptions;
import com.oracle.truffle.tools.chromeinspector.instrument.Token;
import com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import com.oracle.truffle.tools.utils.java_websocket.WebSocket;
import com.oracle.truffle.tools.utils.java_websocket.WebSocketAdapter;
import com.oracle.truffle.tools.utils.java_websocket.WebSocketImpl;
import com.oracle.truffle.tools.utils.java_websocket.WebSocketServerFactory;
import com.oracle.truffle.tools.utils.java_websocket.drafts.Draft;
import com.oracle.truffle.tools.utils.java_websocket.framing.Framedata;
import com.oracle.truffle.tools.utils.java_websocket.framing.PingFrame;
import com.oracle.truffle.tools.utils.java_websocket.handshake.ClientHandshake;
import com.oracle.truffle.tools.utils.java_websocket.server.DefaultSSLWebSocketServerFactory;
import com.oracle.truffle.tools.utils.java_websocket.server.DefaultWebSocketServerFactory;
import com.oracle.truffle.tools.utils.java_websocket.server.WebSocketServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.graalvm.polyglot.io.MessageEndpoint;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public final class InspectorServer
extends WebSocketServer
implements InspectorWSConnection {
    private static final String WS_PREFIX = "ws://";
    private static final String WS_PREFIX_SECURE = "wss://";
    private static final String DEV_TOOLS_PREFIX = "devtools://devtools/bundled/js_app.html?";
    private static final Map<InetSocketAddress, InspectorServer> SERVERS = new HashMap<InetSocketAddress, InspectorServer>();
    private final boolean secure;
    private final Map<Token, ServerPathSession> sessions = new ConcurrentHashMap<Token, ServerPathSession>();
    private final Map<WebSocket, InspectWebSocketHandler> socketConnectionHandlers = new ConcurrentHashMap<WebSocket, InspectWebSocketHandler>();
    private final CountDownLatch started = new CountDownLatch(1);

    private InspectorServer(InetSocketAddress isa, KeyStoreOptions keyStoreOptions) throws IOException {
        super(isa, 2);
        this.setConnectionLostTimeout(0);
        WrappingSocketServerFactory wssf = keyStoreOptions != null ? new WrappingSocketServerFactory(new DefaultSSLWebSocketServerFactory(InspectorServer.sslContext(keyStoreOptions))) : new WrappingSocketServerFactory(new DefaultWebSocketServerFactory());
        this.setWebSocketFactory(wssf);
        this.setReuseAddr(true);
        this.secure = keyStoreOptions != null;
    }

    private static SSLContext sslContext(KeyStoreOptions keyStoreOptions) throws IOException {
        String keyStoreFile = keyStoreOptions.getKeyStore();
        if (keyStoreFile != null) {
            SSLContext sslContext;
            String filePasswordProperty = keyStoreOptions.getKeyStorePassword();
            char[] filePassword = filePasswordProperty == null ? "".toCharArray() : filePasswordProperty.toCharArray();
            try {
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream in = new FileInputStream(keyStoreFile);){
                    keystore.load(in, filePassword);
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keystore, filePassword);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keystore);
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            return sslContext;
        }
        throw new IOException("Use options to specify the keystore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InspectorServer get(InetSocketAddress isa, Token token, String pathContainingToken, InspectorExecutionContext context, boolean debugBrk, boolean secure, KeyStoreOptions keyStoreOptions, ConnectionWatcher connectionWatcher, InspectServerSession initialSession) throws IOException {
        InspectorServer wss;
        boolean startServer = false;
        Map<InetSocketAddress, InspectorServer> map = SERVERS;
        synchronized (map) {
            wss = SERVERS.get(isa);
            if (wss == null) {
                wss = new InspectorServer(isa, secure ? keyStoreOptions : null);
                context.logMessage("", "New WebSocketServer at " + String.valueOf(isa));
                startServer = true;
                SERVERS.put(isa, wss);
            }
            if (wss.sessions.containsKey(token)) {
                throw new IOException("Inspector session with the same path exists already on " + isa.getHostString() + ":" + isa.getPort());
            }
            wss.sessions.put(token, new ServerPathSession(context, initialSession, debugBrk, connectionWatcher, pathContainingToken));
        }
        if (startServer) {
            wss.start();
        }
        return wss;
    }

    private HttpResponse handleDnsRebind(HttpRequest request) {
        String host = request.getHeaders().get("host");
        if (!InspectorServer.isHostOk(host)) {
            Object badHost = host != null ? "Bad host " + host + ". Please use IP address." : "Missing host header. Use an up-to-date client.";
            String message = (String)badHost + " This request cannot be served because it looks like DNS rebind attack.";
            Iterator<ServerPathSession> sessionIterator = this.sessions.values().iterator();
            if (sessionIterator.hasNext()) {
                sessionIterator.next().getContext().getErr().println("Bad connection from " + String.valueOf(request.getRemoteAddress()) + ". " + message);
            }
            return new HttpResponse("400 Bad Request", "text/plain", "UTF-8", message);
        }
        return null;
    }

    private static boolean isHostOk(String host) {
        if (host == null) {
            return false;
        }
        String bareHost = host.replaceFirst(":([0-9]+)$", "");
        return bareHost.equals("localhost") || InspectorServer.isValidIp(bareHost);
    }

    private static boolean isValidIp(String host) {
        InetAddress address;
        boolean ipv6 = host.startsWith("[") && host.endsWith("]");
        String h = host;
        if (ipv6) {
            h = h.substring(1, h.length() - 1);
        }
        try {
            address = InetAddress.getByName(h);
        }
        catch (UnknownHostException ex) {
            return false;
        }
        return address instanceof Inet4Address == !ipv6;
    }

    public String getWSAddress(Token token) {
        ServerPathSession serverSession = this.sessions.get(token);
        return this.getWSAddress(serverSession);
    }

    private String getWSAddress(ServerPathSession serverSession) {
        String prefix = this.secure ? WS_PREFIX_SECURE : WS_PREFIX;
        try {
            this.started.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return prefix + this.getAddress().getAddress().getHostAddress() + ":" + this.getPort() + serverSession.pathContainingToken;
    }

    public String getDevtoolsAddress(Token token) {
        return InspectorServer.getDevtoolsAddress(this.getWSAddress(token));
    }

    private static String getDevtoolsAddress(String wsAddress) {
        return DEV_TOOLS_PREFIX + wsAddress.replace("://", "=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        InetSocketAddress address = this.getAddress();
        if (address.getPort() == 0) {
            InetSocketAddress realAddress = new InetSocketAddress(address.getAddress(), this.getPort());
            Map<InetSocketAddress, InspectorServer> map = SERVERS;
            synchronized (map) {
                InspectorServer wss = SERVERS.remove(address);
                assert (wss == this);
                SERVERS.put(realAddress, wss);
            }
        }
        this.started.countDown();
    }

    @Override
    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        String uri = handshake.getResourceDescriptor();
        Token token = Token.createHashedTokenFromString(uri);
        ServerPathSession session = this.sessions.get(token);
        if (session != null) {
            InspectWebSocketHandler iws;
            InspectServerSession iss = session.getServerSession();
            if (iss == null) {
                boolean debugBreak = Boolean.TRUE.equals(session.getDebugBrkAndReset());
                iss = InspectServerSession.create(session.getContext(), debugBreak, session.getConnectionWatcher());
            }
            session.activeWS = iws = new InspectWebSocketHandler(token, conn, iss, session.getConnectionWatcher());
            iss.context.logMessage("CLIENT ws connection opened, token = ", token);
            this.socketConnectionHandlers.put(conn, iws);
        } else {
            conn.close(1003, "Bad path.");
        }
    }

    @Override
    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        InspectWebSocketHandler iws = this.socketConnectionHandlers.remove(conn);
        if (iws != null) {
            iws.didClose();
        }
    }

    @Override
    public void onMessage(WebSocket conn, String message) {
        InspectWebSocketHandler iws = this.socketConnectionHandlers.get(conn);
        if (iws != null) {
            iws.onMessage(message);
        }
    }

    @Override
    public void onError(WebSocket conn, Exception ex) {
        if (conn == null) {
            Iterator<ServerPathSession> sessionIterator = this.sessions.values().iterator();
            if (sessionIterator.hasNext()) {
                PrintWriter err = sessionIterator.next().getContext().getErr();
                err.println("WebSocket Error:");
                ex.printStackTrace(err);
            }
            return;
        }
        InspectWebSocketHandler iws = this.socketConnectionHandlers.get(conn);
        if (iws != null) {
            iws.onException(ex);
        }
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        InspectWebSocketHandler iws = this.socketConnectionHandlers.get(conn);
        if (iws != null) {
            iws.onPing();
        }
        super.onWebsocketPing(conn, f);
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
        InspectWebSocketHandler iws = this.socketConnectionHandlers.get(conn);
        if (iws != null) {
            iws.onPong();
        }
        super.onWebsocketPong(conn, f);
    }

    @Override
    public PingFrame onPreparePing(WebSocket conn) {
        InspectWebSocketHandler iws = this.socketConnectionHandlers.get(conn);
        if (iws != null) {
            iws.onPreparePing();
        }
        return super.onPreparePing(conn);
    }

    @Override
    public void consoleAPICall(Token token, String type, Object text) {
        InspectWebSocketHandler iws;
        ServerPathSession sps = this.sessions.get(token);
        if (sps != null && (iws = sps.activeWS) != null) {
            iws.iss.consoleAPICall(type, text);
        }
    }

    @Override
    public void close(Token token) throws IOException {
        ServerPathSession sps = this.sessions.remove(token);
        if (sps != null) {
            InspectWebSocketHandler iws = sps.activeWS;
            if (iws != null) {
                iws.connection.close(1001);
            }
            sps.dispose();
        }
        if (this.sessions.isEmpty()) {
            try {
                this.stop();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws InterruptedException {
        Map<InetSocketAddress, InspectorServer> map = SERVERS;
        synchronized (map) {
            Iterator<Map.Entry<InetSocketAddress, InspectorServer>> entries = SERVERS.entrySet().iterator();
            while (entries.hasNext()) {
                if (entries.next().getValue() != this) continue;
                entries.remove();
                break;
            }
        }
        super.stop();
    }

    private class WrappingSocketServerFactory
    implements WebSocketServerFactory {
        private final WebSocketServerFactory delegate;

        WrappingSocketServerFactory(WebSocketServerFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter wsa, Draft draft) {
            return this.delegate.createWebSocket(wsa, draft);
        }

        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter wsa, List<Draft> list) {
            return this.delegate.createWebSocket(wsa, (List)list);
        }

        @Override
        public ByteChannel wrapChannel(SocketChannel channel, SelectionKey key) throws IOException {
            return new HTTPChannelWrapper(channel, new DNSRebindProtectionHandler(), new JSONHandler());
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    private static class ServerPathSession {
        private final InspectorExecutionContext context;
        private final AtomicReference<InspectServerSession> serverSession;
        private final AtomicBoolean debugBrk;
        private final ConnectionWatcher connectionWatcher;
        private final String pathContainingToken;
        volatile InspectWebSocketHandler activeWS;

        ServerPathSession(InspectorExecutionContext context, InspectServerSession serverSession, boolean debugBrk, ConnectionWatcher connectionWatcher, String pathContainingToken) {
            this.context = context;
            this.serverSession = new AtomicReference<InspectServerSession>(serverSession);
            this.debugBrk = new AtomicBoolean(debugBrk);
            this.connectionWatcher = connectionWatcher;
            this.pathContainingToken = pathContainingToken;
        }

        InspectorExecutionContext getContext() {
            return this.context;
        }

        InspectServerSession getServerSession() {
            return this.serverSession.getAndSet(null);
        }

        boolean getDebugBrkAndReset() {
            return this.debugBrk.getAndSet(false);
        }

        ConnectionWatcher getConnectionWatcher() {
            return this.connectionWatcher;
        }

        void dispose() {
            InspectServerSession iss = this.serverSession.getAndSet(null);
            if (iss != null) {
                iss.dispose();
            } else {
                InspectWebSocketHandler iws = this.activeWS;
                if (iws != null) {
                    iws.disposeSession();
                }
            }
        }
    }

    public static final class HttpRequest {
        private final InetSocketAddress remoteAddress;
        private final String method;
        private final String uri;
        private final String version;
        private final Map<String, String> headers = new LinkedHashMap<String, String>();

        HttpRequest(InetSocketAddress remoteAddress, String method, String uri, String version) {
            this.remoteAddress = remoteAddress;
            this.method = method;
            this.uri = uri;
            this.version = version;
        }

        private void addHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        private Object getMethod() {
            return this.method;
        }

        private String getUri() {
            return this.uri;
        }

        private String getVersion() {
            return this.version;
        }

        private Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    public static final class HttpResponse {
        private final String status;
        private final String contentType;
        private final String encoding;
        private final String content;
        private final Map<String, String> headers = new LinkedHashMap<String, String>();

        HttpResponse(String status, String contentType, String encoding, String content) {
            this.status = status;
            this.contentType = contentType;
            this.encoding = encoding;
            this.content = content;
        }

        public void addHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public void writeTo(ByteChannel channel) throws IOException {
            HttpResponse.write(channel, this.status, this.contentType, this.encoding, this.headers, this.content);
        }

        public static void write404(ByteChannel channel) throws IOException {
            HttpResponse.write(channel, "404", "text/plain", StandardCharsets.US_ASCII.name(), Collections.emptyMap(), "");
        }

        public static void write400(ByteChannel channel, String text) throws IOException {
            HttpResponse.write(channel, "400 Bad Request", "text/plain", StandardCharsets.US_ASCII.name(), Collections.emptyMap(), text);
        }

        private static void write(ByteChannel channel, String status, String contentType, String encodingOrig, Map<String, String> headers, String content) throws IOException {
            byte[] bytes;
            String encoding = encodingOrig;
            try {
                Charset charset = Charset.forName(encoding);
                CharsetEncoder newEncoder = charset.newEncoder();
                if (!newEncoder.canEncode(content)) {
                    charset = StandardCharsets.UTF_8;
                    encoding = charset.name();
                }
                bytes = content.getBytes(charset);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                bytes = new byte[]{};
            }
            HttpResponse.write(channel, ("HTTP/1.1 " + status + " \r\n").getBytes(StandardCharsets.US_ASCII));
            HttpResponse.writeHeader(channel, "Content-Type", contentType + "; charset=" + encoding);
            for (Map.Entry<String, String> header : headers.entrySet()) {
                HttpResponse.writeHeader(channel, header.getKey(), header.getValue());
            }
            HttpResponse.writeHeader(channel, "Content-Length", Integer.toString(bytes.length));
            HttpResponse.write(channel, "\r\n".getBytes(StandardCharsets.US_ASCII));
            channel.write(ByteBuffer.wrap(bytes));
        }

        private static void write(ByteChannel channel, byte[] bytes) throws IOException {
            channel.write(ByteBuffer.wrap(bytes));
        }

        private static void writeHeader(ByteChannel channel, String name, String value) throws IOException {
            HttpResponse.write(channel, (name + ": " + value + "\r\n").getBytes(StandardCharsets.US_ASCII));
        }
    }

    private class InspectWebSocketHandler {
        private final Token token;
        private final WebSocket connection;
        private final InspectServerSession iss;
        private final ConnectionWatcher connectionWatcher;

        InspectWebSocketHandler(Token token, WebSocket connection, InspectServerSession iss, ConnectionWatcher connectionWatcher) {
            this.token = token;
            this.connection = connection;
            this.iss = iss;
            this.connectionWatcher = connectionWatcher;
            this.init();
        }

        private void init() {
            this.iss.context.logMessage("CLIENT web socket connection opened.", "");
            this.connectionWatcher.notifyOpen();
            this.iss.open(new MessageEndpoint(){

                public void sendText(String message) throws IOException {
                    InspectWebSocketHandler.this.iss.context.logMessage("SERVER: ", message);
                    InspectWebSocketHandler.this.connection.send(message);
                }

                public void sendBinary(ByteBuffer data) throws IOException {
                    throw new UnsupportedOperationException("Binary messages are not supported.");
                }

                public void sendPing(ByteBuffer data) throws IOException {
                }

                public void sendPong(ByteBuffer data) throws IOException {
                }

                public void sendClose() throws IOException {
                    InspectWebSocketHandler.this.connection.close(1000);
                }
            });
        }

        void didClose() {
            this.iss.context.logMessage("CLIENT web socket connection closed.", "");
            this.connectionWatcher.notifyClosing();
            ServerPathSession sps = InspectorServer.this.sessions.get(this.token);
            if (sps != null) {
                sps.activeWS = null;
            }
            try {
                this.iss.sendClose();
            }
            catch (IOException e) {
                this.iss.context.logException(e);
            }
        }

        void onMessage(String message) {
            this.iss.context.logMessage("CLIENT: ", message);
            try {
                this.iss.sendText(message);
            }
            catch (IOException e) {
                this.iss.context.logException(e);
            }
        }

        void onException(Exception exception) {
            this.iss.context.logException("CLIENT: ", exception);
        }

        void onPreparePing() {
            this.iss.context.logMessage("SERVER: ", "SENDING PING");
        }

        void onPing() {
            this.iss.context.logMessage("CLIENT: ", "PING");
        }

        void onPong() {
            this.iss.context.logMessage("CLIENT: ", "PONG");
        }

        void disposeSession() {
            this.iss.dispose();
        }
    }

    private static class HTTPChannelWrapper
    implements ByteChannel {
        private final Function<HttpRequest, HttpResponse>[] interceptors;
        private final SocketChannel channel;
        private final ByteBuffer buffer = ByteBuffer.allocate(16384);
        private boolean wsUpgraded = false;

        @SafeVarargs
        HTTPChannelWrapper(SocketChannel channel, Function<HttpRequest, HttpResponse> ... interceptors) {
            this.channel = channel;
            this.interceptors = interceptors;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.wsUpgraded) {
                return this.channel.read(dst);
            }
            this.buffer.clear();
            int r = this.channel.read(this.buffer);
            if (r > 0) {
                this.buffer.flip();
                HttpRequest httpRequest = this.readHttpRequest();
                if ("Upgrade".equalsIgnoreCase(httpRequest.getHeaders().get("connection")) && httpRequest.getHeaders().get("sec-websocket-key") != null) {
                    assert (!httpRequest.getVersion().isEmpty());
                    this.wsUpgraded = true;
                    this.buffer.rewind();
                    dst.put(this.buffer);
                    return r;
                }
                this.writeHttpResponse(httpRequest);
                this.close();
                r = 0;
            }
            return r;
        }

        private HttpRequest readHttpRequest() throws IOException {
            String line = Draft.readStringLine(this.buffer);
            StringTokenizer tokens = new StringTokenizer(line);
            if (!tokens.hasMoreTokens()) {
                HttpResponse.write400(this.channel, "Bad Request: method is missing");
            }
            String method = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                HttpResponse.write400(this.channel, "Bad Request: URI is missing");
            }
            String uri = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                HttpResponse.write400(this.channel, "Bad Request: protocol version is missing");
            }
            String version = tokens.nextToken();
            HttpRequest request = new HttpRequest((InetSocketAddress)this.channel.getRemoteAddress(), method, uri, version);
            while ((line = Draft.readStringLine(this.buffer)) != null && !line.trim().isEmpty()) {
                int p = line.indexOf(58);
                if (p < 0) continue;
                request.addHeader(line.substring(0, p).trim().toLowerCase(Locale.ENGLISH), line.substring(p + 1).trim());
            }
            return request;
        }

        private void writeHttpResponse(HttpRequest request) throws IOException {
            for (Function<HttpRequest, HttpResponse> interceptor : this.interceptors) {
                HttpResponse response = interceptor.apply(request);
                if (response == null) continue;
                response.writeTo(this.channel);
                return;
            }
            HttpResponse.write404(this.channel);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            if (this.wsUpgraded) {
                return this.channel.write(src);
            }
            throw new IOException("Unexpected write of " + String.valueOf(src));
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }

    private class JSONHandler
    implements Function<HttpRequest, HttpResponse> {
        private JSONHandler() {
        }

        @Override
        public HttpResponse apply(HttpRequest request) {
            if ("GET".equals(request.getMethod())) {
                URI uri;
                String uriStr = request.getUri();
                try {
                    uri = new URI(uriStr);
                }
                catch (URISyntaxException ex) {
                    return null;
                }
                String uriPath = uri.getPath();
                String responseJson = null;
                if ("/json/version".equals(uriPath)) {
                    JSONObject version = new JSONObject();
                    version.put("Browser", (Object)"GraalVM");
                    version.put("Protocol-Version", (Object)"1.2");
                    responseJson = version.toString();
                }
                if ("/json".equals(uriPath) || "/json/list".equals(uriPath)) {
                    JSONArray json = new JSONArray();
                    for (ServerPathSession serverPathSession : InspectorServer.this.sessions.values()) {
                        String path = serverPathSession.pathContainingToken;
                        JSONObject info = new JSONObject();
                        info.put("description", (Object)"GraalVM");
                        info.put("faviconUrl", (Object)"https://assets-cdn.github.com/images/icons/emoji/unicode/1f680.png");
                        String ws = InspectorServer.this.getWSAddress(serverPathSession);
                        info.put("devtoolsFrontendUrl", (Object)InspectorServer.getDevtoolsAddress(ws));
                        info.put("id", (Object)path.substring(1));
                        info.put("title", (Object)"GraalVM");
                        info.put("type", (Object)"node");
                        info.put("webSocketDebuggerUrl", (Object)ws);
                        json.put((Object)info);
                    }
                    responseJson = json.toString();
                }
                if (responseJson != null) {
                    HttpResponse response = new HttpResponse("200", "application/json", "UTF-8", responseJson);
                    response.addHeader("Cache-Control", "no-cache,no-store,must-revalidate");
                    response.addHeader("Pragma", "no-cache");
                    response.addHeader("X-Content-Type-Options", "nosniff");
                    return response;
                }
            }
            return null;
        }
    }

    private class DNSRebindProtectionHandler
    implements Function<HttpRequest, HttpResponse> {
        private DNSRebindProtectionHandler() {
        }

        @Override
        public HttpResponse apply(HttpRequest request) {
            return InspectorServer.this.handleDnsRebind(request);
        }
    }
}

