/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.util.function.Supplier;

final class Tracing {
    private Tracing() {
    }

    public static void withTracing(Span span, Runnable runnable) {
        Tracing.withTracing(span, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T withTracing(Span span, Supplier<T> supplier) {
        try {
            T t;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    t = supplier.get();
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        span.setStatus(StatusCode.ERROR, t2.getMessage());
                        span.recordException(t2, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
                        throw t2;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }
}

