/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchConfig;
import io.trino.plugin.tpch.TpchRecordSet;
import io.trino.plugin.tpch.TpchSplit;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchColumnType;
import io.trino.tpch.TpchColumnTypes;
import io.trino.tpch.TpchEntity;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Objects;

public class TpchRecordSetProvider
implements ConnectorRecordSetProvider {
    private final DecimalTypeMapping decimalTypeMapping;

    @Inject
    public TpchRecordSetProvider(TpchConfig config) {
        this(Objects.requireNonNull(config, "config is null").getDecimalTypeMapping());
    }

    public TpchRecordSetProvider(DecimalTypeMapping decimalTypeMapping) {
        this.decimalTypeMapping = Objects.requireNonNull(decimalTypeMapping, "decimalTypeMapping is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        TpchSplit tpchSplit = (TpchSplit)split;
        TpchTableHandle tpchTable = (TpchTableHandle)table;
        return this.getRecordSet(TpchTable.getTable((String)tpchTable.tableName()), columns, tpchTable.scaleFactor(), tpchSplit.getPartNumber(), tpchSplit.getTotalParts(), tpchTable.constraint());
    }

    public <E extends TpchEntity> RecordSet getRecordSet(TpchTable<E> table, List<? extends ColumnHandle> columns, double scaleFactor, int partNumber, int totalParts, TupleDomain<ColumnHandle> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = ((TpchColumnHandle)columnHandle).columnName();
            if (columnName.equalsIgnoreCase("row_number")) {
                builder.add(new RowNumberTpchColumn());
                continue;
            }
            builder.add((Object)table.getColumn(columnName));
        }
        return TpchRecordSet.createTpchRecordSet(table, builder.build(), this.decimalTypeMapping, scaleFactor, partNumber + 1, totalParts, predicate);
    }

    private static class RowNumberTpchColumn<E extends TpchEntity>
    implements TpchColumn<E> {
        private RowNumberTpchColumn() {
        }

        public String getColumnName() {
            return "row_number";
        }

        public TpchColumnType getType() {
            return TpchColumnTypes.IDENTIFIER;
        }

        public double getDouble(E entity) {
            throw new UnsupportedOperationException();
        }

        public long getIdentifier(E entity) {
            return entity.rowNumber();
        }

        public int getInteger(E entity) {
            throw new UnsupportedOperationException();
        }

        public String getString(E entity) {
            throw new UnsupportedOperationException();
        }

        public int getDate(E entity) {
            throw new UnsupportedOperationException();
        }
    }
}

