/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.base.Preconditions;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

public record TpchTableHandle(String schemaName, String tableName, double scaleFactor, TupleDomain<ColumnHandle> constraint) implements ConnectorTableHandle
{
    public TpchTableHandle(String schemaName, String tableName, double scaleFactor) {
        this(schemaName, tableName, scaleFactor, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public TpchTableHandle {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"Scale factor must be larger than 0");
        Objects.requireNonNull(constraint, "constraint is null");
    }

    @Override
    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

