/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing.dflt;

import com.github.curiousoddman.rgxgen.model.SymbolRange;
import com.github.curiousoddman.rgxgen.nodes.Node;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConstantsProvider {
    public static final SymbolRange SMALL_LATIN_LETTERS = SymbolRange.range('a', 'z');
    public static final SymbolRange CAPITAL_LATIN_LETTERS = SymbolRange.range('A', 'Z');
    public static final SymbolRange DIGITS = SymbolRange.range('0', '9');
    public static final char[] ZERO_LENGTH_CHARACTER_ARRAY = new char[0];
    public static final BigInteger BIG_INTEGER_TWO = BigInteger.valueOf(2L);
    public static final int SPACE_ASCII_CODE = 32;
    public static final int DEL_ASCII_CODE = 127;
    public static final int MAX_UNICODE_CHARACTER = 55295;
    public static final SymbolRange ASCII_SYMBOL_RANGE = SymbolRange.range(32, 126);
    public static final SymbolRange UNICODE_SYMBOL_RANGE = SymbolRange.range(32, 55295);
    public static final int HEX_RADIX = 16;
    public static final Node[] EMPTY_NODES_ARR = new Node[0];
    public static final SymbolRange ASCII_DIGITS = SymbolRange.range('0', '9');

    public static char[] getAsciiWhitespaces() {
        return new char[]{'\t', '\n', '\u000b', '\f', '\r', ' '};
    }

    public static List<SymbolRange> getAsciiWordCharRanges() {
        return Collections.unmodifiableList(Arrays.asList(SMALL_LATIN_LETTERS, CAPITAL_LATIN_LETTERS, DIGITS));
    }

    public static char[] makeAsciiCharacterArray() {
        char[] characters = new char[95];
        for (int i = 32; i < 127; ++i) {
            characters[i - 32] = (char)i;
        }
        return characters;
    }
}

