/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.csv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.FieldValueProviders;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.util.Objects;

public class CsvColumnDecoder {
    private final String columnName;
    private final Type columnType;
    private final int columnIndex;

    public CsvColumnDecoder(DecoderColumnHandle columnHandle) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)columnHandle.getName());
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            this.columnType = columnHandle.getType();
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            try {
                this.columnIndex = Integer.parseInt(columnHandle.getMapping());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("invalid mapping '%s' for column '%s'", columnHandle.getMapping(), this.columnName));
            }
            Preconditions.checkArgument((this.columnIndex >= 0 ? 1 : 0) != 0, (String)"invalid mapping '%s' for column '%s'", (Object)columnHandle.getMapping(), (Object)this.columnName);
            Preconditions.checkArgument((boolean)CsvColumnDecoder.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType.getDisplayName(), (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private static boolean isSupportedType(Type type) {
        if (type instanceof VarcharType) {
            return true;
        }
        return ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE).contains((Object)type);
    }

    public FieldValueProvider decodeField(final String[] tokens) {
        if (this.columnIndex >= tokens.length) {
            return FieldValueProviders.nullValueProvider();
        }
        return new FieldValueProvider(this){
            final /* synthetic */ CsvColumnDecoder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isNull() {
                return tokens[this.this$0.columnIndex].isEmpty();
            }

            @Override
            public boolean getBoolean() {
                try {
                    return Boolean.parseBoolean(tokens[this.this$0.columnIndex].trim());
                }
                catch (NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", tokens[this.this$0.columnIndex].trim(), this.this$0.columnType, this.this$0.columnName));
                }
            }

            @Override
            public long getLong() {
                try {
                    return Long.parseLong(tokens[this.this$0.columnIndex].trim());
                }
                catch (NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", tokens[this.this$0.columnIndex].trim(), this.this$0.columnType, this.this$0.columnName));
                }
            }

            @Override
            public double getDouble() {
                try {
                    return Double.parseDouble(tokens[this.this$0.columnIndex].trim());
                }
                catch (NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", tokens[this.this$0.columnIndex].trim(), this.this$0.columnType, this.this$0.columnName));
                }
            }

            @Override
            public Slice getSlice() {
                return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)tokens[this.this$0.columnIndex]), (Type)this.this$0.columnType);
            }
        };
    }
}

