/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.common.base.CaseFormat;
import com.google.common.io.Resources;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ProtobufUtils {
    private ProtobufUtils() {
    }

    public static Descriptors.FileDescriptor getFileDescriptor(String protoFile) throws Descriptors.DescriptorValidationException {
        return ProtobufUtils.getFileDescriptor(Optional.empty(), protoFile);
    }

    public static Descriptors.FileDescriptor getFileDescriptor(Optional<String> fileName, String protoFile) throws Descriptors.DescriptorValidationException {
        ProtoFileElement protoFileElement = ProtoParser.Companion.parse(Location.get((String)""), protoFile);
        return ProtobufUtils.getFileDescriptor(fileName, protoFileElement);
    }

    public static Descriptors.FileDescriptor getFileDescriptor(Optional<String> fileName, ProtoFileElement protoFileElement) throws Descriptors.DescriptorValidationException {
        Descriptors.FileDescriptor[] dependencies = new Descriptors.FileDescriptor[protoFileElement.getImports().size()];
        HashSet<String> definedMessages = new HashSet<String>();
        int index = 0;
        for (String importStatement : protoFileElement.getImports()) {
            try {
                Descriptors.FileDescriptor fileDescriptor = ProtobufUtils.getFileDescriptor(Optional.of(importStatement), ProtobufUtils.getProtoFile(importStatement));
                fileDescriptor.getMessageTypes().stream().map(Descriptors.Descriptor::getFullName).forEach(definedMessages::add);
                dependencies[index] = fileDescriptor;
                ++index;
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
        DescriptorProtos.FileDescriptorProto.Builder builder = DescriptorProtos.FileDescriptorProto.newBuilder();
        if (protoFileElement.getSyntax() != null) {
            builder.setSyntax(protoFileElement.getSyntax().name());
        }
        fileName.ifPresent(arg_0 -> ((DescriptorProtos.FileDescriptorProto.Builder)builder).setName(arg_0));
        builder.addAllDependency((Iterable)protoFileElement.getImports());
        if (protoFileElement.getPackageName() != null) {
            builder.setPackage(protoFileElement.getPackageName());
        }
        for (TypeElement element : protoFileElement.getTypes()) {
            if (element instanceof MessageElement) {
                builder.addMessageType(ProtobufUtils.processMessage((MessageElement)element, definedMessages));
                definedMessages.add(element.getName());
            }
            if (!(element instanceof EnumElement)) continue;
            builder.addEnumType(ProtobufUtils.processEnum((EnumElement)element));
        }
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)builder.build(), (Descriptors.FileDescriptor[])dependencies);
    }

    public static String getProtoFile(String filePath) throws IOException {
        return Resources.toString((URL)Resources.getResource(ProtobufUtils.class, (String)("/" + filePath)), (Charset)StandardCharsets.UTF_8);
    }

    private static DescriptorProtos.DescriptorProto processMessage(MessageElement message, Set<String> globallyDefinedMessages) {
        DescriptorProtos.DescriptorProto.Builder builder = DescriptorProtos.DescriptorProto.newBuilder();
        builder.setName(message.getName());
        HashSet<String> definedMessages = new HashSet<String>(globallyDefinedMessages);
        for (TypeElement typeElement : message.getNestedTypes()) {
            if (typeElement instanceof EnumElement) {
                builder.addEnumType(ProtobufUtils.processEnum((EnumElement)typeElement));
            }
            if (!(typeElement instanceof MessageElement)) continue;
            builder.addNestedType(ProtobufUtils.processMessage((MessageElement)typeElement, definedMessages));
            definedMessages.add(typeElement.getName());
        }
        for (FieldElement field : message.getFields()) {
            ProtoType protoType = ProtoType.get((String)field.getType());
            DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptor = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(field.getName()).setNumber(field.getTag());
            if (protoType.isMap()) {
                Objects.requireNonNull(protoType.getKeyType(), "keyType is null");
                Objects.requireNonNull(protoType.getValueType(), "valueType is null");
                builder.addNestedType(DescriptorProtos.DescriptorProto.newBuilder().setName(ProtobufUtils.getNameForMapField(field.getName())).setOptions(DescriptorProtos.MessageOptions.newBuilder().setMapEntry(true).build()).addField(ProtobufUtils.processType(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("key").setNumber(1).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL), protoType.getKeyType(), definedMessages)).addField(ProtobufUtils.processType(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("value").setNumber(2).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL), protoType.getValueType(), definedMessages)).build());
                fieldDescriptor.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED).setTypeName(ProtobufUtils.getNameForMapField(field.getName()));
            } else {
                ProtobufUtils.processType(fieldDescriptor, protoType, definedMessages);
            }
            if (field.getLabel() != null && field.getLabel() != Field.Label.ONE_OF) {
                fieldDescriptor.setLabel(ProtobufUtils.getLabel(field.getLabel()));
            }
            if (field.getDefaultValue() != null) {
                fieldDescriptor.setDefaultValue(field.getDefaultValue());
            }
            builder.addField(fieldDescriptor.build());
        }
        return builder.build();
    }

    private static DescriptorProtos.EnumDescriptorProto processEnum(EnumElement enumElement) {
        DescriptorProtos.EnumDescriptorProto.Builder enumBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();
        enumBuilder.setName(enumElement.getName());
        for (EnumConstantElement enumConstant : enumElement.getConstants()) {
            enumBuilder.addValue(DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName(enumConstant.getName()).setNumber(enumConstant.getTag()).build());
        }
        return enumBuilder.build();
    }

    public static DescriptorProtos.FieldDescriptorProto.Builder processType(DescriptorProtos.FieldDescriptorProto.Builder builder, ProtoType type, Set<String> messageNames) {
        switch (type.getSimpleName()) {
            case "double": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE);
            }
            case "float": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT);
            }
            case "int64": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
            }
            case "uint64": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64);
            }
            case "int32": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
            }
            case "fixed64": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64);
            }
            case "fixed32": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32);
            }
            case "bool": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
            }
            case "string": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
            }
            case "group": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_GROUP);
            }
            case "bytes": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
            }
            case "uint32": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32);
            }
            case "sfixed32": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32);
            }
            case "sfixed64": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64);
            }
            case "sint32": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32);
            }
            case "sint64": {
                return builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64);
            }
        }
        builder.setTypeName(type.toString());
        if (messageNames.contains(type.toString())) {
            builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE);
        } else {
            builder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM);
        }
        return builder;
    }

    public static DescriptorProtos.FieldDescriptorProto.Label getLabel(Field.Label label) {
        return switch (label) {
            case Field.Label.OPTIONAL -> DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
            case Field.Label.REPEATED -> DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
            case Field.Label.REQUIRED -> DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
            default -> throw new IllegalArgumentException("Unknown label");
        };
    }

    private static String getNameForMapField(String fieldName) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, fieldName) + "Entry";
    }
}

