/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.ReadType;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.DataReader;
import alluxio.client.block.stream.GrpcBlockingStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.InStreamOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.OpenLocalBlockRequest;
import alluxio.grpc.OpenLocalBlockResponse;
import alluxio.grpc.ReadPType;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NioDataBuffer;
import alluxio.resource.CloseableResource;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.block.io.LocalFileBlockReader;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalFileDataReader
implements DataReader {
    private final LocalFileBlockReader mReader;
    private final long mEnd;
    private final long mChunkSize;
    private long mPos;
    private boolean mClosed;

    private LocalFileDataReader(LocalFileBlockReader reader, long offset, long len, long chunkSize) {
        this.mReader = reader;
        Preconditions.checkArgument((chunkSize > 0L ? 1 : 0) != 0);
        this.mPos = offset;
        this.mEnd = Math.min(this.mReader.getLength(), offset + len);
        this.mChunkSize = chunkSize;
    }

    @Override
    public DataBuffer readChunk() throws IOException {
        if (this.mPos >= this.mEnd) {
            return null;
        }
        ByteBuffer buffer = this.mReader.read(this.mPos, Math.min(this.mChunkSize, this.mEnd - this.mPos));
        NioDataBuffer dataBuffer = new NioDataBuffer(buffer, (long)buffer.remaining());
        this.mPos += dataBuffer.getLength();
        MetricsSystem.counter((String)MetricKey.CLIENT_BYTES_READ_LOCAL.getName()).inc(dataBuffer.getLength());
        MetricsSystem.meter((String)MetricKey.CLIENT_BYTES_READ_LOCAL_THROUGHPUT.getName()).mark(dataBuffer.getLength());
        return dataBuffer;
    }

    @Override
    public long pos() {
        return this.mPos;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mReader.decreaseUsageCount();
    }

    @NotThreadSafe
    public static class Factory
    implements DataReader.Factory {
        private final CloseableResource<BlockWorkerClient> mBlockWorker;
        private final String mPath;
        private final long mLocalReaderChunkSize;
        private final GrpcBlockingStream<OpenLocalBlockRequest, OpenLocalBlockResponse> mStream;
        private LocalFileBlockReader mReader;
        private final long mDataTimeoutMs;
        private boolean mClosed;

        public Factory(FileSystemContext context, WorkerNetAddress address, long blockId, long localReaderChunkSize, InStreamOptions options) throws IOException {
            AlluxioConfiguration conf = context.getClusterConf();
            this.mLocalReaderChunkSize = localReaderChunkSize;
            this.mDataTimeoutMs = conf.getMs(PropertyKey.USER_STREAMING_DATA_READ_TIMEOUT);
            if (conf.getBoolean(PropertyKey.USER_DIRECT_MEMORY_IO_ENABLED)) {
                this.mBlockWorker = null;
                this.mStream = null;
                PropertyKey tierDirPathConf = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{0});
                String storageDir = conf.getString(tierDirPathConf).split(",")[0];
                String workerDir = conf.getString(PropertyKey.WORKER_DATA_FOLDER);
                this.mPath = Paths.get(storageDir, workerDir, Long.toString(blockId)).toString();
                return;
            }
            boolean isPromote = ReadType.fromProto((ReadPType)options.getOptions().getReadType()).isPromote();
            OpenLocalBlockRequest request = OpenLocalBlockRequest.newBuilder().setBlockId(blockId).setPromote(isPromote).build();
            this.mBlockWorker = context.acquireBlockWorkerClient(address);
            try {
                this.mStream = new GrpcBlockingStream(((BlockWorkerClient)this.mBlockWorker.get())::openLocalBlock, conf.getInt(PropertyKey.USER_STREAMING_READER_BUFFER_SIZE_MESSAGES), MoreObjects.toStringHelper(LocalFileDataReader.class).add("request", (Object)request).add("address", (Object)address).toString());
                this.mStream.send(request, this.mDataTimeoutMs);
                OpenLocalBlockResponse response = this.mStream.receive(this.mDataTimeoutMs);
                Preconditions.checkState((boolean)response.hasPath());
                this.mPath = response.getPath();
            }
            catch (Exception e) {
                this.mBlockWorker.close();
                throw e;
            }
            if (!Files.exists(Paths.get(this.mPath, new String[0]), new LinkOption[0])) {
                this.mStream.close();
                this.mBlockWorker.close();
                throw new NotFoundException(String.format("LocalFileDataReader can not find the path:%s", this.mPath));
            }
        }

        @Override
        public DataReader create(long offset, long len) throws IOException {
            if (this.mReader == null) {
                this.mReader = new LocalFileBlockReader(this.mPath);
            }
            Preconditions.checkState((this.mReader.getUsageCount() == 0 ? 1 : 0) != 0);
            this.mReader.increaseUsageCount();
            return new LocalFileDataReader(this.mReader, offset, len, this.mLocalReaderChunkSize);
        }

        @Override
        public void close() throws IOException {
            if (this.mClosed) {
                return;
            }
            try {
                if (this.mReader != null) {
                    this.mReader.close();
                }
                if (this.mStream != null) {
                    this.mStream.close();
                    this.mStream.waitForComplete(this.mDataTimeoutMs);
                }
            }
            finally {
                this.mClosed = true;
                if (this.mBlockWorker != null) {
                    this.mBlockWorker.close();
                }
            }
        }
    }
}

