/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.QuotaManagedPageStoreDir;
import alluxio.client.file.cache.store.RocksPageStore;
import alluxio.master.metastore.rocks.RocksUtils;
import alluxio.resource.CloseableIterator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import org.rocksdb.RocksIterator;

public class RocksPageStoreDir
extends QuotaManagedPageStoreDir {
    private final PageStoreOptions mPageStoreOptions;
    private RocksPageStore mPageStore;

    public RocksPageStoreDir(PageStoreOptions pageStoreOptions, PageStore pageStore, CacheEvictor cacheEvictor) {
        super(pageStoreOptions.getRootDir(), pageStoreOptions.getCacheSize(), cacheEvictor);
        Preconditions.checkState((boolean)(pageStore instanceof RocksPageStore));
        this.mPageStore = (RocksPageStore)pageStore;
        this.mPageStoreOptions = pageStoreOptions;
    }

    @Override
    public PageStore getPageStore() {
        return this.mPageStore;
    }

    @Override
    public void reset() throws IOException {
        this.mPageStore.close();
        PageStoreDir.clear(this.getRootPath());
        this.mPageStore = (RocksPageStore)PageStore.create(this.mPageStoreOptions);
    }

    @Override
    public void scanPages(Consumer<Optional<PageInfo>> pageInfoConsumer) {
        try (CloseableIterator pageIterator = RocksUtils.createCloseableIterator((RocksIterator)this.mPageStore.createNewInterator(), this::parsePageInfo, () -> null, null);){
            Streams.stream((Iterator)pageIterator).forEach(pageInfoConsumer);
        }
    }

    private Optional<PageInfo> parsePageInfo(RocksIterator iter) {
        PageId id = RocksPageStore.getPageIdFromKey(iter.key());
        long size = iter.value().length;
        if (id != null) {
            return Optional.of(new PageInfo(id, size, this));
        }
        return Optional.empty();
    }

    @Override
    public Optional<CacheUsage> getUsage() {
        return Optional.of(new QuotaManagedPageStoreDir.Usage());
    }
}

