/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAPooledConnection;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class EXAConnectionPoolDataSource
implements ConnectionPoolDataSource,
Referenceable {
    private EXAPooledConnection[] pool = new EXAPooledConnection[EXADriver.connectionPoolSize];
    private String exaURL = null;
    private String exaUser = null;
    private String exaPassword = null;
    private boolean noticed = false;

    public String getURL() {
        return this.exaURL;
    }

    public void setURL(String url) {
        this.exaURL = url;
    }

    public String getUrl() {
        return this.getURL();
    }

    public void setUrl(String url) {
        this.setURL(url);
    }

    public void setPassword(String pwd) {
        this.exaPassword = pwd;
    }

    public void setUser(String uid) {
        this.exaUser = uid;
    }

    @Override
    public synchronized PooledConnection getPooledConnection() throws SQLException {
        int pos;
        for (pos = 0; pos < EXADriver.connectionPoolSize; ++pos) {
            if (null == this.pool[pos] || this.pool[pos].isOccupied() || this.pool[pos].getURL() == null || this.pool[pos].getUser() == null || this.pool[pos].getPassword() == null || 0 != this.pool[pos].getURL().compareTo(this.exaURL) || 0 != this.pool[pos].getUser().compareTo(this.exaUser) || 0 != this.pool[pos].getPassword().compareTo(this.exaPassword)) continue;
            this.pool[pos].isNowOccupied();
            if (this.pool[pos].getConnectionPtr() != null) {
                ((EXAConnection)this.pool[pos].getConnectionPtr()).clientLog("from EXAConnectionPoolDataSource: getPooledConnection() reuse");
            }
            return this.pool[pos];
        }
        for (pos = 0; pos < EXADriver.connectionPoolSize; ++pos) {
            if (null == this.pool[pos]) {
                this.pool[pos] = new EXAPooledConnection();
            }
            if (this.pool[pos].getURL() != null || this.pool[pos].getUser() != null || this.pool[pos].getPassword() != null) continue;
            this.pool[pos].setURL(this.exaURL);
            this.pool[pos].setUser(this.exaUser);
            this.pool[pos].setPassword(this.exaPassword);
            this.pool[pos].isNowOccupied();
            if (this.pool[pos].getConnectionPtr() != null) {
                ((EXAConnection)this.pool[pos].getConnectionPtr()).clientLog("from EXAConnectionPoolDataSource: getPooledConnection() new");
                this.noticed = false;
                if (false) {
                    ((EXAConnection)this.pool[pos].getConnectionPtr()).clientLog("    EXADriver.connectionPoolSize=" + EXADriver.connectionPoolSize);
                    this.noticed = true;
                }
            }
            this.pool[pos].clearListeners();
            return this.pool[pos];
        }
        for (pos = 0; pos < EXADriver.connectionPoolSize; ++pos) {
            if (this.pool[pos].isOccupied()) continue;
            this.pool[pos].close();
            this.pool[pos].setURL(this.exaURL);
            this.pool[pos].setUser(this.exaUser);
            this.pool[pos].setPassword(this.exaPassword);
            this.pool[pos].getConnection();
            this.pool[pos].isNowOccupied();
            if (this.pool[pos].getConnectionPtr() != null) {
                ((EXAConnection)this.pool[pos].getConnectionPtr()).clientLog("from EXAConnectionPoolDataSource: getPooledConnection() reopen");
            }
            this.pool[pos].clearListeners();
            return this.pool[pos];
        }
        throw new SQLException("Connection pool is full");
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        this.setUser(user);
        this.setPassword(password);
        return this.getPooledConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        return null;
    }
}

