/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.RC4_encoder;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;

class EXAInputStream
extends InputStream {
    static final boolean trace = false;
    final EXAConnection connection;
    protected InputStream father;
    ExecutionStatus executionStatus;
    int inputStreamTimeoutInMs = 10000;
    private byte[] buffer;
    private byte[] bigbuffer;
    private Calendar utcCal;
    private Calendar defCal;

    public EXAInputStream(InputStream f, EXAConnection connection, ExecutionStatus execStat) {
        this.father = f;
        this.buffer = new byte[8];
        this.bigbuffer = new byte[16];
        this.utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.defCal = Calendar.getInstance();
        this.connection = connection;
        this.executionStatus = execStat;
    }

    public EXAInputStream(byte[] bytes, EXAConnection connection) {
        this.father = new ByteArrayInputStream(bytes);
        this.buffer = new byte[8];
        this.bigbuffer = new byte[16];
        this.utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.connection = connection;
    }

    public void SetEncryptor(RC4_encoder enc) throws IOException {
        if (!(this.father instanceof EncryptedInputStream)) {
            throw new IOException("Try to activate encryption on an InputStream that is not an instance of EncryptedInputStream");
        }
        ((EncryptedInputStream)this.father).SetEncryptor(enc);
    }

    @Override
    public int available() throws IOException {
        return this.father.available();
    }

    @Override
    public void close() throws IOException {
        this.father.close();
    }

    @Override
    public void mark(int readlimit) {
        this.father.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.father.markSupported();
    }

    @Override
    public int read() throws IOException {
        int retrys = 8640;
        if (this.connection.testReadTimeout) {
            retrys = EXAConnection.testReadTimeoutVal;
        }
        if (this.connection.getActiveProtocolVersion() >= 9) {
            switch (this.connection.getExecutionMode()) {
                case 11: 
                case 12: 
                case 17: 
                case 38: {
                    retrys = this.connection.getFeedbackInterval() + 30;
                }
            }
        }
        this.connection.SetSocketTimeout(this.inputStreamTimeoutInMs);
        while (retrys > 0) {
            try {
                int erg = this.father.read();
                return erg;
            }
            catch (SocketTimeoutException tex) {
                --retrys;
            }
        }
        throw new IOException(Translator.Socket_failed_to_deliver_any_feedback_from_server());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int retrys = (this.connection.getFeedbackInterval() + 30) * 2;
        if (this.connection.testReadTimeout) {
            retrys = EXAConnection.testReadTimeoutVal;
        }
        if (this.connection.getActiveProtocolVersion() >= 9) {
            switch (this.connection.getExecutionMode()) {
                case 11: 
                case 12: 
                case 17: 
                case 38: {
                    retrys = this.connection.getFeedbackInterval() + 30;
                }
            }
        }
        this.connection.csocket.setSoTimeout(this.inputStreamTimeoutInMs);
        while (retrys > 0) {
            if (this.executionStatus != null && this.executionStatus.wasCanceled() && retrys > 3) {
                retrys = 3;
            }
            try {
                int e2;
                int erg;
                if (erg < 0) {
                    throw new IOException("Read has reached end of the stream (no more data). Bytes Read: " + erg + " Maximum Length to Read: " + len);
                }
                for (erg = this.father.read(b, off, len); erg < len; erg += e2) {
                    e2 = this.father.read(b, off + erg, len - erg);
                    if (e2 >= 0) continue;
                    throw new IOException("Read has reached end of the stream (no more data). Bytes Read: " + e2 + " Maximum Length to Read: " + (len - erg));
                }
                return erg;
            }
            catch (SocketTimeoutException tex) {
                --retrys;
            }
            catch (Exception ex) {
                this.connection.log("read - got an exception: " + ex.getClass().getCanonicalName() + ": " + ex.getMessage());
                throw ex;
            }
        }
        throw new IOException(Translator.Socket_failed_to_deliver_any_feedback_from_server());
    }

    @Override
    public void reset() throws IOException {
        this.father.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.father.skip(n);
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public char readChar() throws IOException {
        return (char)this.read();
    }

    public int readInt() throws IOException {
        this.read(this.buffer, 0, 4);
        return (this.buffer[3] & 0xFF) << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    public short readShort() throws IOException {
        this.read(this.buffer, 0, 2);
        return (short)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    public long readLong() throws IOException {
        this.read(this.buffer, 0, 8);
        return ((long)this.buffer[7] & 0xFFL) << 56 | ((long)this.buffer[6] & 0xFFL) << 48 | ((long)this.buffer[5] & 0xFFL) << 40 | ((long)this.buffer[4] & 0xFFL) << 32 | ((long)this.buffer[3] & 0xFFL) << 24 | ((long)this.buffer[2] & 0xFFL) << 16 | ((long)this.buffer[1] & 0xFFL) << 8 | (long)this.buffer[0] & 0xFFL;
    }

    public double readDouble() throws IOException {
        this.read(this.buffer, 0, 8);
        long h = ((long)this.buffer[7] & 0xFFL) << 56 | ((long)this.buffer[6] & 0xFFL) << 48 | ((long)this.buffer[5] & 0xFFL) << 40 | ((long)this.buffer[4] & 0xFFL) << 32 | ((long)this.buffer[3] & 0xFFL) << 24 | ((long)this.buffer[2] & 0xFFL) << 16 | ((long)this.buffer[1] & 0xFFL) << 8 | (long)this.buffer[0] & 0xFFL;
        return Double.longBitsToDouble(h);
    }

    public float readFloat() throws IOException {
        this.read(this.buffer, 0, 4);
        int h = (this.buffer[3] & 0xFF) << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
        return Float.intBitsToFloat(h);
    }

    public exaTimestamp readTimestamp() throws IOException {
        short year = this.readShort();
        byte month = this.readByte();
        byte day = this.readByte();
        byte hour = this.readByte();
        byte minute = this.readByte();
        byte second = this.readByte();
        int nanos = this.readInt();
        return new exaTimestamp(year, (byte)(month - 1), day, hour, minute, second, nanos);
    }

    public SimpleDate readDate() throws IOException {
        int i = this.readInt();
        return new SimpleDate(i);
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public String readString() throws IOException {
        int size = this.readInt();
        if (size <= 0) {
            return "";
        }
        byte[] mybuffer = new byte[size];
        this.read(mybuffer);
        return new String(mybuffer, this.connection.getEncoding());
    }

    public byte[] readBinary() throws IOException {
        int size = this.readInt();
        if (size <= 0) {
            return new byte[0];
        }
        byte[] mybuffer = new byte[size];
        this.read(mybuffer);
        return mybuffer;
    }

    public boolean nextIsNull() throws IOException {
        return this.readByte() == 0;
    }

    public boolean nextIsValue() throws IOException {
        return this.readByte() != 0;
    }

    public ProtocolAttribute readAttribute() throws IOException {
        short id = this.readShort();
        ProtocolAttribute attrib = new ProtocolAttribute(id);
        switch (attrib.type) {
            case 0: {
                throw new IOException(Translator.Unsupported_attribute() + id);
            }
            case 10: {
                attrib.value = this.readString();
                break;
            }
            case 15: {
                attrib.value = this.readBinary();
                attrib.binaryLength = ((byte[])attrib.value).length;
                break;
            }
            case 4: {
                attrib.value = this.readInt();
                break;
            }
            case 1: {
                attrib.value = this.readByte();
                break;
            }
            case 9: {
                attrib.value = this.readBoolean();
                break;
            }
            case 14: {
                attrib.value = new Date(this.readInt());
                break;
            }
            case 8: {
                attrib.value = this.readDouble();
                break;
            }
            case 5: {
                attrib.value = this.readLong();
                break;
            }
            case 7: {
                attrib.value = Float.valueOf(this.readFloat());
                break;
            }
            case 2: {
                attrib.value = this.readShort();
                break;
            }
            case 21: {
                attrib.value = this.readTimestamp();
                break;
            }
            case 64: {
                attrib.value = this.readBigInteger();
                break;
            }
            default: {
                throw new IOException(Translator.Unsupported_type_of_attribute_value_for_attribute() + id);
            }
        }
        return attrib;
    }

    public BigInteger readBigInteger() throws IOException {
        for (int i = 15; i >= 0; --i) {
            int b = this.read();
            if (b < 0) {
                throw new IOException(Translator.End_of_input_stream());
            }
            this.bigbuffer[i] = (byte)b;
        }
        BigInteger result = new BigInteger(this.bigbuffer);
        return result;
    }
}

