/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.AccessRuleViolation;
import com.exasol.jdbc.ConnectRefused;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.ConnectionToWrongWorker;
import com.exasol.jdbc.DependencyException;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.InvalidSessionID;
import com.exasol.jdbc.LoaderException;
import com.exasol.jdbc.NoResultException;
import com.exasol.jdbc.PolicyException;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.QueueServerException;
import com.exasol.jdbc.RollbackException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLSyntaxErrorException;

public abstract class ExceptionFactory {
    public static SQLException createSQLException(EXASQLException ex, EXAConnection connection) {
        return ExceptionFactory.createSQLException(ex.getMessage(), ex.getSQLCode(), connection);
    }

    public static SQLException mergeSQLExceptions(SQLException ex1, SQLException ex2) {
        return new SQLException(ex1.toString() + "; " + ex2.getSQLState() + " " + ex2.toString(), ex1.getSQLState());
    }

    public static SQLException createSQLException(String msg, String state, EXAConnection connection) {
        if (state.startsWith("22")) {
            return new SQLDataException(msg, state);
        }
        if (state.startsWith("27") || msg.toLowerCase().contains("constraint violation")) {
            return new SQLIntegrityConstraintViolationException(msg, state);
        }
        if (msg.toLowerCase().contains("syntax error")) {
            return new SQLSyntaxErrorException(msg, state);
        }
        if (state.startsWith("08")) {
            if ("08003".equals(state)) {
                return new InvalidSessionID(msg);
            }
            if ("08004".equals(state)) {
                if (msg.contains("Connection exception - This node has already accepted a sub-connection within the same parallel session")) {
                    return new ConnectionToWrongWorker(msg, state, connection.getSessionID());
                }
                return new SQLInvalidAuthorizationSpecException(msg, "28000");
            }
            if ("08X00".equals(state)) {
                return new SQLInvalidAuthorizationSpecException(msg, state);
            }
            if ("08005".equals(state)) {
                return new ConnectRefused(msg);
            }
            if ("08006".equalsIgnoreCase(state)) {
                return new ConnectionLost(msg, connection.getSessionID());
            }
            if ("08007".equals(state)) {
                return new ProtocolException(msg);
            }
            return new ConnectionException(msg, state);
        }
        if (state.startsWith("42P")) {
            if ("42P01".equals(state)) {
                return new PolicyException(msg);
            }
            if ("42P02".equals(state)) {
                return new DependencyException(msg);
            }
            return new QueueServerException(msg, state);
        }
        if (state.startsWith("425")) {
            return new AccessRuleViolation(msg, state);
        }
        if (state.startsWith("X0")) {
            return new LoaderException(msg, state);
        }
        if (state.startsWith("02")) {
            return new NoResultException(msg, state);
        }
        if (state.startsWith("400")) {
            if ("40001".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40002".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40003".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40004".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40005".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40007".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40008".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40009".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40010".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40011".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40017".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40018".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40019".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40020".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40021".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40022".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40021".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40022".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("00000".equals(state) && connection.isWorkerConnection()) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40023".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40024".equals(state)) {
                return new ConnectionLost(msg, state, connection.getSessionID());
            }
            if ("40025".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40026".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40027".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40028".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40029".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40030".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40031".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40032".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("40033".equals(state)) {
                return new RollbackException(msg, state);
            }
            if ("R0007".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0008".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0009".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0010".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0011".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0012".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0013".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0014".equals(state)) {
                return new SQLException(msg, state);
            }
            if ("R0033".equals(state)) {
                return new SQLException(msg, state);
            }
        }
        return new SQLException(msg, state);
    }
}

