/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GSSPrivilegedAction
implements PrivilegedAction<Exception> {
    private final EXAConnection connection;
    private final boolean useSpnego;
    private final GSSCredential credentials;

    public GSSPrivilegedAction(EXAConnection conn, GSSCredential credentials, boolean usespnego) {
        this.credentials = credentials;
        this.connection = conn;
        this.useSpnego = usespnego;
    }

    private static boolean canUseSPNEGO(GSSManager manager) throws GSSException {
        Oid[] mechs;
        Oid spnego = new Oid("1.3.6.1.5.5.2");
        for (Oid mech : mechs = manager.getMechs()) {
            if (!mech.equals(spnego)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Exception run() {
        try {
            GSSManager manager = GSSManager.getInstance();
            GSSCredential clientCredentials = null;
            Oid[] oids = new Oid[1];
            if (this.credentials == null) {
                oids[0] = this.useSpnego && GSSPrivilegedAction.canUseSPNEGO(manager) ? new Oid("1.3.6.1.5.5.2") : new Oid("1.2.840.113554.1.2.2");
                GSSName clientName = manager.createName(this.connection.getKerberosUserName(), GSSName.NT_USER_NAME);
                clientCredentials = manager.createCredential(clientName, 28800, oids, 1);
            } else {
                oids[0] = new Oid("1.2.840.113554.1.2.2");
                clientCredentials = this.credentials;
            }
            GSSName serverName = manager.createName(this.connection.getKerberosTargetNameGSS(), GSSName.NT_HOSTBASED_SERVICE);
            this.connection.log("GSSPrivilegedAction: GSSName=" + serverName + ", Oid=" + oids[0].toString());
            GSSContext securityContext = manager.createContext(serverName, oids[0], clientCredentials, 0);
            securityContext.requestMutualAuth(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            boolean established = false;
            while (!established) {
                outToken = securityContext.initSecContext(inToken, 0, inToken.length);
                if (securityContext.isEstablished()) {
                    this.connection.getAttributes();
                    established = true;
                }
                if (outToken != null) {
                    inToken = this.connection.exchangeTicket(outToken);
                }
                outToken = null;
            }
        }
        catch (IOException ioex) {
            this.connection.log("GSSPrivilegedAction: IOException: " + ioex.getMessage());
            this.connection.logStackTrace(ioex);
            return ioex;
        }
        catch (GSSException gsse) {
            this.connection.log("GSSPrivilegedAction: GSSException: " + gsse.getMessage());
            this.connection.logStackTrace(gsse);
            return gsse;
        }
        catch (SQLException sex) {
            this.connection.log("GSSPrivilegedAction: SQLException: " + sex.getSQLState() + " - " + sex.getMessage());
            this.connection.logStackTrace(sex);
            return sex;
        }
        return null;
    }
}

