/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Header;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutMessage {
    final EXAConnection connection;
    private EXAOutputStream out;
    private ByteArrayOutputStream outData;
    private Header header;
    private DebugLog debug;

    public OutMessage(DebugLog log, EXAConnection connection) {
        this.connection = connection;
        this.outData = new ByteArrayOutputStream();
        this.out = new EXAOutputStream(this.outData, connection);
        this.debug = log;
        this.header = new Header(connection, log, connection.getNextSerialNumber());
    }

    public EXAOutputStream getStream() {
        return this.out;
    }

    public Header getHeader() {
        return this.header;
    }

    public void flush() throws IOException {
        this.out.flush();
        this.header.setSize(this.outData.size());
    }

    public void write_to(OutputStream os, EXAConnection connection) throws IOException, ConnectionException {
        try {
            this.out.flush();
            this.header.write_to(os);
            os.write(this.outData.toByteArray());
        }
        finally {
            this.outData.reset();
        }
    }

    public void write_to_and_no_clean(OutputStream os, EXAConnection connection) throws IOException, ConnectionException {
        this.out.flush();
        this.header.write_to(os);
        os.write(this.outData.toByteArray());
        os.flush();
    }
}

