/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.ConnectionParser;
import com.exasol.jdbc.importExport.ImportExportQuery;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportErrorQuery
extends ImportExportQuery {
    public final String ClassName = "ImportErrorQuery";
    protected final String ForthPartKey = "ForthPart";
    protected final String FifthPartKey = "FifthPart";
    protected final String SixthPartKey = "SixthPart";
    protected String ForthPart = null;
    protected String FifthPart = null;
    protected String SixthPart = null;
    protected ConnectionParser connectionParser2 = null;
    protected String ErrorFile = null;
    protected boolean IsSecureError = true;

    public String getForthPart() {
        return this.ForthPart;
    }

    public String getFifthPart() {
        return this.FifthPart;
    }

    public String getSixthPart() {
        return this.SixthPart;
    }

    public ConnectionParser getConnectionParser2() {
        return this.connectionParser2;
    }

    public String getErrorFile() {
        return this.ErrorFile;
    }

    public boolean isSecureError() {
        return this.IsSecureError;
    }

    ImportErrorQuery(String sql, boolean isCSV, boolean isSecure, boolean isSecureError) {
        super(sql, isCSV, isSecure);
        this.IsSecureError = isSecureError;
    }

    @Override
    public void parse() throws SQLException {
        Matcher matcher = Pattern.compile("(?<FirstPart>.*?)(?<SecondPart>\\s+LOCAL\\s+.*?(SECURE.*?)?(CSV|FBV).*?FILE.*?['\"][^'\"]+['\"].*)(?<ThirdPart>.*?)(?<ForthPart>ERRORS.*?INTO.*?)(?<FifthPart>\\s+LOCAL\\s+.*?(SECURE.*?)?CSV.*?FILE.*?['\"][^'\"]+['\"])(?<SixthPart>.*)", 42).matcher(this.SQL);
        if (matcher.matches()) {
            this.FirstPart = matcher.group("FirstPart");
            this.SecondPart = matcher.group("SecondPart");
            this.ThirdPart = matcher.group("ThirdPart");
            this.ForthPart = matcher.group("ForthPart");
            this.FifthPart = matcher.group("FifthPart");
            this.SixthPart = matcher.group("SixthPart");
            TwoStrings twoStrings = this.GetRejectLimitErrors(this.SecondPart, this.ThirdPart);
            this.SecondPart = twoStrings.value1;
            this.ThirdPart = twoStrings.value2;
            this.connectionParser = new ConnectionParser(this.SecondPart);
            this.connectionParser.parse();
            if (this.connectionParser.getQuery2() != null && this.connectionParser.getQuery2().length() > 0) {
                this.ThirdPart = this.connectionParser.getQuery2() + " " + this.ThirdPart;
            }
            this.connectionParser2 = new ConnectionParser(this.FifthPart);
            this.connectionParser2.parse();
            if (this.connectionParser2.GetFiles().size() > 1) {
                throw new SQLException("Maximum 1 File is allowed for errors.");
            }
            if (this.connectionParser2.getQuery2() != null && this.connectionParser2.getQuery2().length() > 0) {
                this.SixthPart = this.connectionParser2.getQuery2() + " " + this.SixthPart;
            }
        } else {
            throw new SQLException("SQL Syntax is invalid");
        }
        this.ErrorFile = this.connectionParser2.GetFiles().get(0);
        this.ValidateCertificateParameters();
    }

    @Override
    public void ValidateCertificateParameters() throws SQLException {
        boolean inEndCertificateParams;
        boolean inMiddleCertificateParams = this.connectionParser.getCertificateParam() != null || this.connectionParser.getPublicKey() != null;
        String inEndCertificateParameter = ConnectionParser.GetCertificateParameter(this.SixthPart);
        String inEndPublicKey = ConnectionParser.GetPublicKey(this.SixthPart);
        boolean bl = inEndCertificateParams = inEndCertificateParameter != null || inEndPublicKey != null;
        if (inMiddleCertificateParams && inEndCertificateParams) {
            throw new SQLException("Certificate Parameters are provided in multiple places.");
        }
        if (inMiddleCertificateParams) {
            this.CertificateParameter = this.connectionParser.getCertificateParam();
            this.PublicKey = this.connectionParser.getPublicKey();
        }
        if (inEndCertificateParams) {
            this.CertificateParameter = inEndCertificateParameter;
            this.PublicKey = inEndPublicKey;
            if (null != this.PublicKey) {
                this.SixthPart = this.SixthPart.replace(this.PublicKey, "");
            }
            if (null != this.CertificateParameter) {
                this.SixthPart = this.SixthPart.replace(this.CertificateParameter, "");
            }
        }
    }

    protected TwoStrings GetRejectLimitErrors(String sql, String sql2) {
        Matcher matcher = Pattern.compile("(\\s*REJECT\\s+LIMIT.*ERRORS.*)", 42).matcher(sql);
        String _str1 = null;
        String _str2 = null;
        if (matcher.find()) {
            int startIndx = matcher.start();
            int endIndx = matcher.end();
            String _str3 = sql.substring(0, startIndx);
            String _str4 = sql.substring(startIndx, endIndx);
            String _str5 = sql.substring(endIndx);
            _str1 = _str3 + " " + _str5;
            _str2 = _str4 + sql2;
        }
        TwoStrings obj = new TwoStrings();
        obj.value1 = _str1 != null ? _str1 : sql;
        obj.value2 = _str2 != null ? _str2 : sql2;
        return obj;
    }

    protected class TwoStrings {
        public String value1 = null;
        public String value2 = null;

        protected TwoStrings() {
        }
    }
}

